/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.DamPermissionEntity;
import com.geosegbar.entities.StatusEntity;
import com.geosegbar.entities.UserEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

@Entity
@Table(name="client", indexes={@Index(name="idx_client_name", columnList="name", unique=true), @Index(name="idx_client_email", columnList="email", unique=true), @Index(name="idx_client_status", columnList="status_id"), @Index(name="idx_client_phone", columnList="phone"), @Index(name="idx_client_whatsapp", columnList="whatsapp_phone"), @Index(name="idx_client_email_contact", columnList="email_contact"), @Index(name="idx_client_city", columnList="city"), @Index(name="idx_client_state", columnList="state"), @Index(name="idx_client_city_state", columnList="city, state"), @Index(name="idx_client_zip_code", columnList="zip_code"), @Index(name="idx_client_status_name", columnList="status_id, name"), @Index(name="idx_client_status_city", columnList="status_id, city"), @Index(name="idx_client_state_status", columnList="state, status_id")})
public class ClientEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotBlank(message="Nome \u00e9 obrigat\u00f3rio!")
    @Column(nullable=false, unique=true)
    private @NotBlank(message="Nome \u00e9 obrigat\u00f3rio!") String name;
    @NotBlank(message="Email \u00e9 obrigat\u00f3rio!")
    @Email(message="Email inv\u00e1lido!")
    @Column(nullable=false, unique=true)
    private @NotBlank(message="Email \u00e9 obrigat\u00f3rio!") @Email(message="Email inv\u00e1lido!") String email;
    @NotBlank(message="O nome da rua \u00e9 obrigat\u00f3rio!")
    @Column(nullable=false)
    private @NotBlank(message="O nome da rua \u00e9 obrigat\u00f3rio!") String street;
    @NotBlank(message="O nome do bairro \u00e9 obrigat\u00f3rio!")
    @Size(max=100, message="O nome do bairro deve ter no m\u00e1ximo 100 caracteres!")
    @Column(nullable=false, length=100)
    private @NotBlank(message="O nome do bairro \u00e9 obrigat\u00f3rio!") @Size(max=100, message="O nome do bairro deve ter no m\u00e1ximo 100 caracteres!") String neighborhood;
    @Pattern(regexp="^[0-9]+$", message="O n\u00famero do endere\u00e7o deve conter apenas n\u00fameros!")
    @Size(max=10, message="O n\u00famero do endere\u00e7o deve ter no m\u00e1ximo 10 caracteres!")
    @Column(length=10)
    private @Pattern(regexp="^[0-9]+$", message="O n\u00famero do endere\u00e7o deve conter apenas n\u00fameros!") @Size(max=10, message="O n\u00famero do endere\u00e7o deve ter no m\u00e1ximo 10 caracteres!") String numberAddress;
    @NotBlank(message="O nome da cidade \u00e9 obrigat\u00f3rio!")
    @Pattern(regexp="^[A-Za-z\u00c0-\u00ff\\s]+$", message="Cidade n\u00e3o pode conter n\u00fameros!")
    @Size(max=100, message="O nome da cidade deve ter no m\u00e1ximo 100 caracteres!")
    @Column(nullable=false, length=100)
    private @NotBlank(message="O nome da cidade \u00e9 obrigat\u00f3rio!") @Pattern(regexp="^[A-Za-z\u00c0-\u00ff\\s]+$", message="Cidade n\u00e3o pode conter n\u00fameros!") @Size(max=100, message="O nome da cidade deve ter no m\u00e1ximo 100 caracteres!") String city;
    @NotBlank(message="O nome do estado \u00e9 obrigat\u00f3rio!")
    @Pattern(regexp="^[A-Za-z\u00c0-\u00ff\\s]+$", message="Estado n\u00e3o pode conter n\u00fameros!")
    @Size(max=100, message="O nome do estado deve ter no m\u00e1ximo 100 caracteres!")
    @Column(nullable=false, length=100)
    private @NotBlank(message="O nome do estado \u00e9 obrigat\u00f3rio!") @Pattern(regexp="^[A-Za-z\u00c0-\u00ff\\s]+$", message="Estado n\u00e3o pode conter n\u00fameros!") @Size(max=100, message="O nome do estado deve ter no m\u00e1ximo 100 caracteres!") String state;
    @NotBlank(message="CEP \u00e9 obrigat\u00f3rio!")
    @Pattern(regexp="^\\d{5}-?\\d{3}$", message="CEP inv\u00e1lido!")
    @Column(nullable=false, length=9)
    private @NotBlank(message="CEP \u00e9 obrigat\u00f3rio!") @Pattern(regexp="^\\d{5}-?\\d{3}$", message="CEP inv\u00e1lido!") String zipCode;
    @Size(max=100, message="O complemento deve ter no m\u00e1ximo 100 caracteres!")
    @Column(length=100)
    private @Size(max=100, message="O complemento deve ter no m\u00e1ximo 100 caracteres!") String complement;
    @NotBlank(message="O telefone \u00e9 obrigat\u00f3rio!")
    @Pattern(regexp="^\\d{10,11}$", message="O telefone deve conter 10 ou 11 d\u00edgitos num\u00e9ricos!")
    @Column(nullable=false, length=11)
    private @NotBlank(message="O telefone \u00e9 obrigat\u00f3rio!") @Pattern(regexp="^\\d{10,11}$", message="O telefone deve conter 10 ou 11 d\u00edgitos num\u00e9ricos!") String phone;
    @Pattern(regexp="^\\d{10,11}$", message="O WhatsApp deve conter 10 ou 11 d\u00edgitos num\u00e9ricos!")
    @Size(max=11, message="O WhatsApp deve conter 10 ou 11 d\u00edgitos num\u00e9ricos!")
    @Column(length=11)
    private @Pattern(regexp="^\\d{10,11}$", message="O WhatsApp deve conter 10 ou 11 d\u00edgitos num\u00e9ricos!") @Size(max=11, message="O WhatsApp deve conter 10 ou 11 d\u00edgitos num\u00e9ricos!") String whatsappPhone;
    @Email(message="Email inv\u00e1lido!")
    @Size(max=150, message="O email de contato deve ter no m\u00e1ximo 150 caracteres!")
    @Column(length=150)
    private @Email(message="Email inv\u00e1lido!") @Size(max=150, message="O email de contato deve ter no m\u00e1ximo 150 caracteres!") String emailContact;
    @Column(nullable=true)
    private String logoPath;
    @ManyToOne
    @JoinColumn(name="status_id")
    private StatusEntity status;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @OneToMany(mappedBy="client", fetch=FetchType.LAZY)
    private Set<DamEntity> dams = new HashSet();
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @ManyToMany(mappedBy="clients", fetch=FetchType.LAZY)
    private Set<UserEntity> users = new HashSet();
    @JsonIgnore
    @OneToMany(mappedBy="client", fetch=FetchType.LAZY)
    private Set<DamPermissionEntity> damPermissions = new HashSet();

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getStreet() {
        return this.street;
    }

    @Generated
    public String getNeighborhood() {
        return this.neighborhood;
    }

    @Generated
    public String getNumberAddress() {
        return this.numberAddress;
    }

    @Generated
    public String getCity() {
        return this.city;
    }

    @Generated
    public String getState() {
        return this.state;
    }

    @Generated
    public String getZipCode() {
        return this.zipCode;
    }

    @Generated
    public String getComplement() {
        return this.complement;
    }

    @Generated
    public String getPhone() {
        return this.phone;
    }

    @Generated
    public String getWhatsappPhone() {
        return this.whatsappPhone;
    }

    @Generated
    public String getEmailContact() {
        return this.emailContact;
    }

    @Generated
    public String getLogoPath() {
        return this.logoPath;
    }

    @Generated
    public StatusEntity getStatus() {
        return this.status;
    }

    @Generated
    public Set<DamEntity> getDams() {
        return this.dams;
    }

    @Generated
    public Set<UserEntity> getUsers() {
        return this.users;
    }

    @Generated
    public Set<DamPermissionEntity> getDamPermissions() {
        return this.damPermissions;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setStreet(String street) {
        this.street = street;
    }

    @Generated
    public void setNeighborhood(String neighborhood) {
        this.neighborhood = neighborhood;
    }

    @Generated
    public void setNumberAddress(String numberAddress) {
        this.numberAddress = numberAddress;
    }

    @Generated
    public void setCity(String city) {
        this.city = city;
    }

    @Generated
    public void setState(String state) {
        this.state = state;
    }

    @Generated
    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    @Generated
    public void setComplement(String complement) {
        this.complement = complement;
    }

    @Generated
    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Generated
    public void setWhatsappPhone(String whatsappPhone) {
        this.whatsappPhone = whatsappPhone;
    }

    @Generated
    public void setEmailContact(String emailContact) {
        this.emailContact = emailContact;
    }

    @Generated
    public void setLogoPath(String logoPath) {
        this.logoPath = logoPath;
    }

    @Generated
    public void setStatus(StatusEntity status) {
        this.status = status;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Generated
    public void setDams(Set<DamEntity> dams) {
        this.dams = dams;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Generated
    public void setUsers(Set<UserEntity> users) {
        this.users = users;
    }

    @JsonIgnore
    @Generated
    public void setDamPermissions(Set<DamPermissionEntity> damPermissions) {
        this.damPermissions = damPermissions;
    }

    @Generated
    public ClientEntity() {
    }

    @Generated
    public ClientEntity(Long id, String name, String email, String street, String neighborhood, String numberAddress, String city, String state, String zipCode, String complement, String phone, String whatsappPhone, String emailContact, String logoPath, StatusEntity status, Set<DamEntity> dams, Set<UserEntity> users, Set<DamPermissionEntity> damPermissions) {
        this.id = id;
        this.name = name;
        this.email = email;
        this.street = street;
        this.neighborhood = neighborhood;
        this.numberAddress = numberAddress;
        this.city = city;
        this.state = state;
        this.zipCode = zipCode;
        this.complement = complement;
        this.phone = phone;
        this.whatsappPhone = whatsappPhone;
        this.emailContact = emailContact;
        this.logoPath = logoPath;
        this.status = status;
        this.dams = dams;
        this.users = users;
        this.damPermissions = damPermissions;
    }
}

