/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.common.utils;

import com.geosegbar.entities.RoutineInspectionPermissionEntity;
import com.geosegbar.entities.UserEntity;
import com.geosegbar.exceptions.UnauthorizedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class AuthenticatedUserUtil {
    public static UserEntity getCurrentUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || !authentication.isAuthenticated() || authentication.getPrincipal() == null) {
            throw new UnauthorizedException("Usu\u00e1rio n\u00e3o autenticado");
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof UserEntity) {
            return (UserEntity)principal;
        }
        throw new UnauthorizedException("Erro ao obter usu\u00e1rio autenticado");
    }

    public static boolean isAdmin() {
        UserEntity user = AuthenticatedUserUtil.getCurrentUser();
        return user.getRole().getName().toString().equals("ADMIN");
    }

    public static void checkAdminPermission() {
        if (!AuthenticatedUserUtil.isAdmin()) {
            throw new UnauthorizedException("Acesso negado. Permiss\u00e3o de administrador necess\u00e1ria.");
        }
    }

    public static void checkRole(String ... roles) {
        UserEntity user = AuthenticatedUserUtil.getCurrentUser();
        String userRole = user.getRole().getName().toString();
        for (String role : roles) {
            if (!userRole.equals(role)) continue;
            return;
        }
        throw new UnauthorizedException("Acesso negado. Permiss\u00e3o insuficiente para esta opera\u00e7\u00e3o.");
    }

    public static boolean hasRoutineInspectionPermission(boolean isMobile) {
        UserEntity currentUser = AuthenticatedUserUtil.getCurrentUser();
        if (currentUser.getRole().getName().toString().equals("ADMIN")) {
            return true;
        }
        RoutineInspectionPermissionEntity permissions = currentUser.getRoutineInspectionPermission();
        return permissions != null;
    }
}

