/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.permissions.instrumentation_permission.services;

import com.geosegbar.entities.InstrumentationPermissionEntity;
import com.geosegbar.entities.UserEntity;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.permissions.instrumentation_permission.dtos.InstrumentationPermissionDTO;
import com.geosegbar.infra.permissions.instrumentation_permission.persistence.InstrumentationPermissionRepository;
import com.geosegbar.infra.user.persistence.jpa.UserRepository;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InstrumentationPermissionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstrumentationPermissionService.class);
    private final InstrumentationPermissionRepository instrPermissionRepository;
    private final UserRepository userRepository;

    public List<InstrumentationPermissionEntity> findAll() {
        return this.instrPermissionRepository.findAll();
    }

    public InstrumentationPermissionEntity findById(Long id) {
        return (InstrumentationPermissionEntity)this.instrPermissionRepository.findById(id).orElseThrow(() -> new NotFoundException("Permiss\u00e3o de instrumenta\u00e7\u00e3o n\u00e3o encontrada com ID: " + id));
    }

    public InstrumentationPermissionEntity findByUser(Long userId) {
        UserEntity user = (UserEntity)this.userRepository.findById(userId).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + userId));
        return this.instrPermissionRepository.findByUser(user).orElseThrow(() -> new NotFoundException("Permiss\u00e3o de instrumenta\u00e7\u00e3o n\u00e3o encontrada para o usu\u00e1rio"));
    }

    @Transactional
    public InstrumentationPermissionEntity createOrUpdate(InstrumentationPermissionDTO permissionDTO) {
        InstrumentationPermissionEntity permission;
        UserEntity user = (UserEntity)this.userRepository.findById(permissionDTO.getUserId()).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + permissionDTO.getUserId()));
        Optional<InstrumentationPermissionEntity> existingPermission = this.instrPermissionRepository.findByUser(user);
        if (existingPermission.isPresent()) {
            permission = existingPermission.get();
        } else {
            permission = new InstrumentationPermissionEntity();
            permission.setUser(user);
        }
        permission.setViewGraphs(permissionDTO.getViewGraphs());
        permission.setEditGraphsLocal(permissionDTO.getEditGraphsLocal());
        permission.setEditGraphsDefault(permissionDTO.getEditGraphsDefault());
        permission.setViewRead(permissionDTO.getViewRead());
        permission.setEditRead(permissionDTO.getEditRead());
        permission.setViewSections(permissionDTO.getViewSections());
        permission.setEditSections(permissionDTO.getEditSections());
        return (InstrumentationPermissionEntity)this.instrPermissionRepository.save(permission);
    }

    @Transactional
    public void delete(Long id) {
        if (!this.instrPermissionRepository.existsById(id)) {
            throw new NotFoundException("Permiss\u00e3o de instrumenta\u00e7\u00e3o n\u00e3o encontrada com ID: " + id);
        }
        this.instrPermissionRepository.deleteById(id);
    }

    @Transactional
    public void deleteByUser(Long userId) {
        UserEntity user = (UserEntity)this.userRepository.findById(userId).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + userId));
        if (!this.instrPermissionRepository.existsByUser(user)) {
            throw new NotFoundException("Permiss\u00e3o de instrumenta\u00e7\u00e3o n\u00e3o encontrada para o usu\u00e1rio");
        }
        InstrumentationPermissionEntity permission = this.instrPermissionRepository.findByUser(user).get();
        permission.setUser(null);
        this.instrPermissionRepository.delete(permission);
    }

    @Transactional
    public void deleteByUserSafely(Long userId) {
        try {
            UserEntity user = (UserEntity)this.userRepository.findById(userId).orElseThrow(() -> new NotFoundException("Usu\u00e1rio n\u00e3o encontrado com ID: " + userId));
            if (this.instrPermissionRepository.existsByUser(user)) {
                InstrumentationPermissionEntity permission = this.instrPermissionRepository.findByUser(user).get();
                user.setInstrumentationPermission(null);
                permission.setUser(null);
                this.userRepository.save(user);
                this.instrPermissionRepository.save(permission);
                this.instrPermissionRepository.delete(permission);
            }
        }
        catch (Exception e) {
            log.error("Error while trying to delete instrumentation permission for user {}: {}", new Object[]{userId, e.getMessage(), e});
        }
    }

    @Transactional
    public InstrumentationPermissionEntity createDefaultPermission(UserEntity user) {
        if (this.instrPermissionRepository.existsByUser(user)) {
            log.info("Instrumentation permission already exists for user {}", (Object)user.getId());
            return this.instrPermissionRepository.findByUser(user).get();
        }
        InstrumentationPermissionEntity permission = new InstrumentationPermissionEntity();
        permission.setUser(user);
        permission.setViewGraphs(false);
        permission.setEditGraphsLocal(false);
        permission.setEditGraphsDefault(false);
        permission.setViewRead(false);
        permission.setEditRead(false);
        permission.setViewSections(false);
        permission.setEditSections(false);
        InstrumentationPermissionEntity savedPermission = (InstrumentationPermissionEntity)this.instrPermissionRepository.save(permission);
        return savedPermission;
    }

    @Generated
    public InstrumentationPermissionService(InstrumentationPermissionRepository instrPermissionRepository, UserRepository userRepository) {
        this.instrPermissionRepository = instrPermissionRepository;
        this.userRepository = userRepository;
    }
}

