/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.instrument_graph_pattern.services;

import com.geosegbar.entities.DeterministicLimitEntity;
import com.geosegbar.entities.InstrumentEntity;
import com.geosegbar.entities.InstrumentGraphAxesEntity;
import com.geosegbar.entities.InstrumentGraphCustomizationPropertiesEntity;
import com.geosegbar.entities.InstrumentGraphPatternEntity;
import com.geosegbar.entities.InstrumentGraphPatternFolder;
import com.geosegbar.entities.StatisticalLimitEntity;
import com.geosegbar.exceptions.DuplicateResourceException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.dam.services.DamService;
import com.geosegbar.infra.instrument.persistence.jpa.InstrumentRepository;
import com.geosegbar.infra.instrument_graph_axes.persistence.jpa.InstrumentGraphAxesRepository;
import com.geosegbar.infra.instrument_graph_pattern.dtos.CreateGraphPatternRequest;
import com.geosegbar.infra.instrument_graph_pattern.dtos.GraphPatternDetailResponseDTO;
import com.geosegbar.infra.instrument_graph_pattern.dtos.GraphPatternResponseDTO;
import com.geosegbar.infra.instrument_graph_pattern.persistence.jpa.InstrumentGraphPatternRepository;
import com.geosegbar.infra.instrument_graph_pattern_folder.persistence.jpa.InstrumentGraphPatternFolderRepository;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.Hibernate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InstrumentGraphPatternService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstrumentGraphPatternService.class);
    private final InstrumentRepository instrumentRepository;
    private final InstrumentGraphPatternRepository patternRepository;
    private final InstrumentGraphAxesRepository axesRepository;
    private final InstrumentGraphPatternFolderRepository folderRepository;
    private final DamService damService;

    @Cacheable(value={"graphPatternsByInstrument"}, key="#instrumentId", cacheManager="instrumentGraphCacheManager")
    public List<GraphPatternResponseDTO> findByInstrument(Long instrumentId) {
        return this.patternRepository.findByInstrumentId(instrumentId).stream().map(this::mapToResponseDTO).collect(Collectors.toList());
    }

    @Cacheable(value={"graphPatternsByInstrument"}, key="'details-' + #instrumentId", cacheManager="instrumentGraphCacheManager")
    public List<GraphPatternDetailResponseDTO> findByInstrumentWithDetails(Long instrumentId) {
        return this.patternRepository.findByInstrumentIdWithAllDetails(instrumentId).stream().map(this::mapToDetailResponseDTO).collect(Collectors.toList());
    }

    public InstrumentGraphPatternEntity findById(Long id) {
        return (InstrumentGraphPatternEntity)this.patternRepository.findById(id).orElseThrow(() -> new NotFoundException("Padr\u00e3o de Gr\u00e1fico n\u00e3o encontrado com ID: " + id + "."));
    }

    @Cacheable(value={"graphPatternsByDam"}, key="#damId", cacheManager="instrumentGraphCacheManager")
    public List<GraphPatternDetailResponseDTO> findAllPatternsByDam(Long damId) {
        this.damService.findById(damId);
        List<InstrumentGraphPatternEntity> patterns = this.patternRepository.findByInstrumentDamIdWithAllDetails(damId);
        List<GraphPatternDetailResponseDTO> patternDTOs = patterns.stream().map(this::mapToDetailResponseDTO).collect(Collectors.toList());
        log.info("Patterns de barragem obtidos: damId={}, totalPatterns={}", (Object)damId, (Object)patternDTOs.size());
        return patternDTOs;
    }

    @CacheEvict(value={"graphPatternById", "graphPatternsByInstrument", "graphPatternsByDam", "folderWithPatterns", "damFoldersWithPatterns"}, allEntries=true, cacheManager="instrumentGraphCacheManager")
    public GraphPatternDetailResponseDTO updateNameGraphPattern(Long id, String newName) {
        InstrumentGraphPatternEntity pattern = this.findById(id);
        if (this.patternRepository.existsByNameAndInstrumentId(newName, pattern.getInstrument().getId())) {
            throw new DuplicateResourceException("J\u00e1 existe um Padr\u00e3o de Gr\u00e1fico com o nome '" + newName + "' para este instrumento!");
        }
        pattern.setName(newName);
        return this.mapToDetailResponseDTO((InstrumentGraphPatternEntity)this.patternRepository.save(pattern));
    }

    @Cacheable(value={"graphPatternById"}, key="#id", cacheManager="instrumentGraphCacheManager")
    public GraphPatternDetailResponseDTO findByIdWithDetails(Long id) {
        InstrumentGraphPatternEntity pattern = this.patternRepository.findByIdWithAllDetails(id).orElseThrow(() -> new NotFoundException("Padr\u00e3o de Gr\u00e1fico n\u00e3o encontrado com ID: " + id + "."));
        return this.mapToDetailResponseDTO(pattern);
    }

    @Transactional
    @CacheEvict(value={"graphPatternById", "graphPatternsByInstrument", "graphPatternsByDam", "folderWithPatterns", "damFoldersWithPatterns", "graphProperties", "graphAxes"}, allEntries=true, cacheManager="instrumentGraphCacheManager")
    public void deleteById(Long patternId) {
        this.findById(patternId);
        this.patternRepository.deleteById(patternId);
        log.info("Pattern exclu\u00eddo: id={}", (Object)patternId);
    }

    @Transactional
    @CacheEvict(value={"graphPatternsByInstrument", "graphPatternsByDam", "folderWithPatterns", "damFoldersWithPatterns"}, allEntries=true, cacheManager="instrumentGraphCacheManager")
    public GraphPatternResponseDTO create(CreateGraphPatternRequest request) {
        if (this.patternRepository.existsByNameAndInstrumentId(request.getName(), request.getInstrumentId())) {
            throw new DuplicateResourceException("J\u00e1 existe um Padr\u00e3o de Gr\u00e1fico com o nome '" + request.getName() + "' para este instrumento!");
        }
        InstrumentEntity instrument = (InstrumentEntity)this.instrumentRepository.findById(request.getInstrumentId()).orElseThrow(() -> new NotFoundException("Instrumento n\u00e3o encontrado com ID: " + request.getInstrumentId()));
        InstrumentGraphPatternFolder folder = null;
        if (request.getFolderId() != null) {
            folder = (InstrumentGraphPatternFolder)this.folderRepository.findById(request.getFolderId()).orElseThrow(() -> new NotFoundException("Pasta n\u00e3o encontrada com ID: " + request.getFolderId()));
        }
        InstrumentGraphPatternEntity pattern = new InstrumentGraphPatternEntity();
        pattern.setName(request.getName());
        pattern.setInstrument(instrument);
        pattern.setFolder(folder);
        pattern = (InstrumentGraphPatternEntity)this.patternRepository.save(pattern);
        InstrumentGraphAxesEntity axes = new InstrumentGraphAxesEntity();
        axes.setPattern(pattern);
        axes.setAbscissaPx(14);
        axes.setPrimaryOrdinatePx(14);
        axes.setSecondaryOrdinatePx(14);
        axes.setAbscissaGridLinesEnable(true);
        axes.setPrimaryOrdinateGridLinesEnable(true);
        this.axesRepository.save(axes);
        pattern.setAxes(axes);
        this.patternRepository.save(pattern);
        log.info("Pattern criado: id={}, name={}, instrumentId={}, folderId={}", new Object[]{pattern.getId(), pattern.getName(), instrument.getId(), folder != null ? folder.getId() : null});
        return this.mapToResponseDTO(pattern);
    }

    public GraphPatternResponseDTO mapToResponseDTO(InstrumentGraphPatternEntity pattern) {
        GraphPatternResponseDTO dto = new GraphPatternResponseDTO();
        dto.setId(pattern.getId());
        dto.setName(pattern.getName());
        dto.setInstrumentId(pattern.getInstrument().getId());
        if (pattern.getFolder() != null) {
            dto.setFolder(new GraphPatternResponseDTO.FolderSummaryDTO(pattern.getFolder().getId(), pattern.getFolder().getName()));
        }
        return dto;
    }

    public GraphPatternDetailResponseDTO mapToDetailResponseDTO(InstrumentGraphPatternEntity pattern) {
        InstrumentGraphPatternEntity finalPattern = !Hibernate.isInitialized(pattern.getProperties()) ? this.patternRepository.findByIdWithAllDetails(pattern.getId()).orElse(pattern) : pattern;
        GraphPatternDetailResponseDTO dto = new GraphPatternDetailResponseDTO();
        dto.setId(finalPattern.getId());
        dto.setName(finalPattern.getName());
        if (finalPattern.getInstrument() != null) {
            dto.setInstrument(new GraphPatternDetailResponseDTO.InstrumentDetailDTO(finalPattern.getInstrument().getId(), finalPattern.getInstrument().getName(), finalPattern.getInstrument().getLocation()));
        }
        if (finalPattern.getFolder() != null) {
            dto.setFolder(new GraphPatternDetailResponseDTO.FolderDetailDTO(finalPattern.getFolder().getId(), finalPattern.getFolder().getName()));
        }
        if (finalPattern.getAxes() != null) {
            InstrumentGraphAxesEntity axes = finalPattern.getAxes();
            dto.setAxes(new GraphPatternDetailResponseDTO.AxesDetailDTO(axes.getId(), axes.getAbscissaPx(), axes.getAbscissaGridLinesEnable(), axes.getPrimaryOrdinatePx(), axes.getSecondaryOrdinatePx(), axes.getPrimaryOrdinateGridLinesEnable(), axes.getPrimaryOrdinateTitle(), axes.getSecondaryOrdinateTitle(), axes.getPrimaryOrdinateSpacing(), axes.getSecondaryOrdinateSpacing(), axes.getPrimaryOrdinateInitialValue(), axes.getSecondaryOrdinateInitialValue(), axes.getPrimaryOrdinateMaximumValue(), axes.getSecondaryOrdinateMaximumValue()));
        }
        if (finalPattern.getProperties() != null) {
            List<GraphPatternDetailResponseDTO.PropertyDetailDTO> properties = finalPattern.getProperties().stream().map(property -> this.mapToPropertyDetailDTO((InstrumentGraphCustomizationPropertiesEntity)property, finalPattern.getInstrument())).collect(Collectors.toList());
            dto.setProperties(properties);
        }
        return dto;
    }

    private GraphPatternDetailResponseDTO.PropertyDetailDTO mapToPropertyDetailDTO(InstrumentGraphCustomizationPropertiesEntity property, InstrumentEntity instrument) {
        GraphPatternDetailResponseDTO.RelatedOutputDTO outputDto;
        GraphPatternDetailResponseDTO.PropertyDetailDTO dto = new GraphPatternDetailResponseDTO.PropertyDetailDTO();
        dto.setId(property.getId());
        dto.setName(property.getName());
        dto.setCustomizationType(property.getCustomizationType());
        dto.setFillColor(property.getFillColor());
        dto.setLineType(property.getLineType());
        dto.setLabelEnable(property.getLabelEnable());
        dto.setIsPrimaryOrdinate(property.getIsPrimaryOrdinate());
        dto.setLimitValueType(property.getLimitValueType());
        if (property.getInstrument() != null) {
            dto.setInstrument(new GraphPatternDetailResponseDTO.RelatedInstrumentDTO(property.getInstrument().getId(), property.getInstrument().getName(), property.getInstrument().getLocation()));
        }
        if (property.getOutput() != null) {
            dto.setOutput(new GraphPatternDetailResponseDTO.RelatedOutputDTO(property.getOutput().getId(), property.getOutput().getAcronym(), property.getOutput().getName()));
        }
        if (property.getConstant() != null) {
            dto.setConstant(new GraphPatternDetailResponseDTO.RelatedConstantDTO(property.getConstant().getId(), property.getConstant().getAcronym(), property.getConstant().getName(), property.getConstant().getValue()));
        }
        if (property.getStatisticalLimit() != null) {
            StatisticalLimitEntity statLimit = property.getStatisticalLimit();
            outputDto = null;
            if (statLimit.getOutput() != null) {
                outputDto = new GraphPatternDetailResponseDTO.RelatedOutputDTO(statLimit.getOutput().getId(), statLimit.getOutput().getAcronym(), statLimit.getOutput().getName());
            }
            dto.setStatisticalLimit(new GraphPatternDetailResponseDTO.RelatedStatisticalLimitDTO(statLimit.getId(), statLimit.getLowerValue(), statLimit.getUpperValue(), outputDto));
        }
        if (property.getDeterministicLimit() != null) {
            DeterministicLimitEntity detLimit = property.getDeterministicLimit();
            outputDto = null;
            if (detLimit.getOutput() != null) {
                outputDto = new GraphPatternDetailResponseDTO.RelatedOutputDTO(detLimit.getOutput().getId(), detLimit.getOutput().getAcronym(), detLimit.getOutput().getName());
            }
            dto.setDeterministicLimit(new GraphPatternDetailResponseDTO.RelatedDeterministicLimitDTO(detLimit.getId(), detLimit.getAttentionValue(), detLimit.getAlertValue(), detLimit.getEmergencyValue(), outputDto));
        }
        return dto;
    }

    @Generated
    public InstrumentGraphPatternService(InstrumentRepository instrumentRepository, InstrumentGraphPatternRepository patternRepository, InstrumentGraphAxesRepository axesRepository, InstrumentGraphPatternFolderRepository folderRepository, DamService damService) {
        this.instrumentRepository = instrumentRepository;
        this.patternRepository = patternRepository;
        this.axesRepository = axesRepository;
        this.folderRepository = folderRepository;
        this.damService = damService;
    }
}

