/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.checklist_response.services;

import com.geosegbar.entities.AnswerEntity;
import com.geosegbar.entities.ChecklistResponseEntity;
import com.geosegbar.entities.ClientEntity;
import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.QuestionEntity;
import com.geosegbar.entities.QuestionnaireResponseEntity;
import com.geosegbar.entities.TemplateQuestionnaireEntity;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.checklist_response.dtos.ChecklistResponseDetailDTO;
import com.geosegbar.infra.checklist_response.dtos.ClientDetailedChecklistResponsesDTO;
import com.geosegbar.infra.checklist_response.dtos.DamInfoDTO;
import com.geosegbar.infra.checklist_response.dtos.DamLastChecklistDTO;
import com.geosegbar.infra.checklist_response.dtos.OptionInfoDTO;
import com.geosegbar.infra.checklist_response.dtos.PagedChecklistResponseDTO;
import com.geosegbar.infra.checklist_response.dtos.PhotoInfoDTO;
import com.geosegbar.infra.checklist_response.dtos.QuestionWithAnswerDTO;
import com.geosegbar.infra.checklist_response.dtos.TemplateWithAnswersDTO;
import com.geosegbar.infra.checklist_response.persistence.jpa.ChecklistResponseRepository;
import com.geosegbar.infra.client.persistence.jpa.ClientRepository;
import com.geosegbar.infra.dam.services.DamService;
import com.geosegbar.infra.questionnaire_response.persistence.jpa.QuestionnaireResponseRepository;
import jakarta.transaction.Transactional;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ChecklistResponseService {
    private final ChecklistResponseRepository checklistResponseRepository;
    private final QuestionnaireResponseRepository questionnaireResponseRepository;
    private final DamService damService;
    private final ClientRepository clientRepository;

    @Cacheable(value={"allChecklistResponses"}, key="'all'", cacheManager="checklistCacheManager")
    public List<ChecklistResponseEntity> findAll() {
        return this.checklistResponseRepository.findAll();
    }

    @Cacheable(value={"checklistResponseById"}, key="#id", cacheManager="checklistCacheManager")
    public ChecklistResponseEntity findById(Long id) {
        return (ChecklistResponseEntity)this.checklistResponseRepository.findById(id).orElseThrow(() -> new NotFoundException("Resposta de Checklist n\u00e3o encontrada para id: " + id));
    }

    @Cacheable(value={"checklistResponsesByDam"}, key="#damId", cacheManager="checklistCacheManager")
    public List<ChecklistResponseEntity> findByDamId(Long damId) {
        this.damService.findById(damId);
        List<ChecklistResponseEntity> responses = this.checklistResponseRepository.findByDamId(damId);
        return responses;
    }

    @Transactional
    @CacheEvict(value={"allChecklistResponses", "checklistResponseById", "checklistResponsesByDam", "checklistResponseDetail", "checklistResponsesByUser", "checklistResponsesByDate", "damLastChecklist", "checklistsWithAnswersByDam", "checklistsWithAnswersByClient"}, allEntries=true, cacheManager="checklistCacheManager")
    public ChecklistResponseEntity save(ChecklistResponseEntity checklistResponse) {
        Long damId = checklistResponse.getDam().getId();
        DamEntity dam = this.damService.findById(damId);
        checklistResponse.setDam(dam);
        return (ChecklistResponseEntity)this.checklistResponseRepository.save(checklistResponse);
    }

    @Transactional
    @CacheEvict(value={"allChecklistResponses", "checklistResponseById", "checklistResponsesByDam", "checklistResponseDetail", "checklistResponsesByUser", "checklistResponsesByDate", "damLastChecklist", "checklistsWithAnswersByDam", "checklistsWithAnswersByClient"}, allEntries=true, cacheManager="checklistCacheManager")
    public ChecklistResponseEntity update(ChecklistResponseEntity checklistResponse) {
        this.checklistResponseRepository.findById(checklistResponse.getId()).orElseThrow(() -> new NotFoundException("Resposta de Checklist n\u00e3o encontrada para atualiza\u00e7\u00e3o!"));
        Long damId = checklistResponse.getDam().getId();
        DamEntity dam = this.damService.findById(damId);
        checklistResponse.setDam(dam);
        return (ChecklistResponseEntity)this.checklistResponseRepository.save(checklistResponse);
    }

    @Transactional
    @CacheEvict(value={"allChecklistResponses", "checklistResponseById", "checklistResponsesByDam", "checklistResponseDetail", "checklistResponsesByUser", "checklistResponsesByDate", "damLastChecklist", "checklistsWithAnswersByDam", "checklistsWithAnswersByClient"}, allEntries=true, cacheManager="checklistCacheManager")
    public void deleteById(Long id) {
        this.checklistResponseRepository.findById(id).orElseThrow(() -> new NotFoundException("Resposta de Checklist n\u00e3o encontrada para exclus\u00e3o!"));
        this.checklistResponseRepository.deleteById(id);
    }

    @Cacheable(value={"checklistResponsesByDam"}, key="#damId", cacheManager="checklistCacheManager")
    public List<ChecklistResponseDetailDTO> findChecklistResponsesByDamId(Long damId) {
        this.damService.findById(damId);
        List<ChecklistResponseEntity> checklistResponses = this.checklistResponseRepository.findByDamId(damId);
        return checklistResponses.stream().map(this::convertToDetailDto).collect(Collectors.toList());
    }

    @Cacheable(value={"checklistResponsesByClient"}, key="#clientId + '_' + #pageable.pageNumber + '_' + #pageable.pageSize", cacheManager="checklistCacheManager")
    public PagedChecklistResponseDTO<ChecklistResponseDetailDTO> findChecklistResponsesByClientIdPaged(Long clientId, Pageable pageable) {
        Page<ChecklistResponseEntity> page = this.checklistResponseRepository.findByClientIdOptimized(clientId, pageable);
        List dtos = page.getContent().stream().map(this::convertToDetailDto).collect(Collectors.toList());
        return new PagedChecklistResponseDTO<ChecklistResponseDetailDTO>(dtos, page.getNumber(), page.getSize(), page.getTotalElements(), page.getTotalPages(), page.isLast(), page.isFirst());
    }

    @Cacheable(value={"checklistResponseDetail"}, key="#checklistResponseId", cacheManager="checklistCacheManager")
    public ChecklistResponseDetailDTO findChecklistResponseById(Long checklistResponseId) {
        ChecklistResponseEntity checklistResponse = this.findById(checklistResponseId);
        return this.convertToDetailDto(checklistResponse);
    }

    private ChecklistResponseDetailDTO convertToDetailDto(ChecklistResponseEntity checklistResponse) {
        ChecklistResponseDetailDTO dto = new ChecklistResponseDetailDTO();
        dto.setId(checklistResponse.getId());
        dto.setChecklistName(checklistResponse.getChecklistName());
        dto.setChecklistId(checklistResponse.getChecklistId());
        dto.setCreatedAt(checklistResponse.getCreatedAt());
        dto.setUserId(checklistResponse.getUser().getId());
        dto.setUserName(checklistResponse.getUser().getName());
        DamEntity dam = checklistResponse.getDam();
        DamInfoDTO damInfo = new DamInfoDTO();
        damInfo.setId(dam.getId());
        damInfo.setName(dam.getName());
        dto.setDam(damInfo);
        List<QuestionnaireResponseEntity> questionnaireResponses = this.questionnaireResponseRepository.findByChecklistResponseIdOptimized(checklistResponse.getId());
        if (questionnaireResponses.isEmpty()) {
            dto.setTemplates(new ArrayList<TemplateWithAnswersDTO>());
            return dto;
        }
        HashMap<Long, TemplateWithAnswersDTO> templateMap = new HashMap<Long, TemplateWithAnswersDTO>();
        for (QuestionnaireResponseEntity qResponse : questionnaireResponses) {
            TemplateQuestionnaireEntity template = qResponse.getTemplateQuestionnaire();
            Long templateId = template.getId();
            TemplateWithAnswersDTO templateDto = templateMap.computeIfAbsent(templateId, id -> new TemplateWithAnswersDTO(templateId, template.getName(), qResponse.getId(), new ArrayList<QuestionWithAnswerDTO>()));
            for (AnswerEntity answer : qResponse.getAnswers()) {
                QuestionEntity question = answer.getQuestion();
                List<OptionInfoDTO> allQuestionOptions = question.getOptions().stream().map(opt -> new OptionInfoDTO(opt.getId(), opt.getLabel())).collect(Collectors.toList());
                List<PhotoInfoDTO> photoDtos = answer.getPhotos().stream().map(photo -> new PhotoInfoDTO(photo.getId(), photo.getImagePath())).collect(Collectors.toList());
                List<OptionInfoDTO> optionDtos = answer.getSelectedOptions().stream().map(option -> new OptionInfoDTO(option.getId(), option.getLabel())).collect(Collectors.toList());
                QuestionWithAnswerDTO questionWithAnswer = new QuestionWithAnswerDTO(question.getId(), question.getQuestionText(), question.getType(), answer.getId(), answer.getComment(), answer.getLatitude(), answer.getLongitude(), optionDtos, photoDtos, allQuestionOptions);
                templateDto.getQuestionsWithAnswers().add(questionWithAnswer);
            }
        }
        ArrayList<TemplateWithAnswersDTO> templates = new ArrayList<TemplateWithAnswersDTO>(templateMap.values());
        dto.setTemplates(templates);
        return dto;
    }

    @Cacheable(value={"checklistResponsesByUser"}, key="#userId", cacheManager="checklistCacheManager")
    public List<ChecklistResponseDetailDTO> findChecklistResponsesByUserId(Long userId) {
        List<ChecklistResponseEntity> checklistResponses = this.checklistResponseRepository.findByUserId(userId);
        return checklistResponses.stream().map(this::convertToDetailDto).collect(Collectors.toList());
    }

    @Cacheable(value={"checklistResponsesByDate"}, key="#startDate.toString() + '_' + #endDate.toString()", cacheManager="checklistCacheManager")
    public List<ChecklistResponseDetailDTO> findChecklistResponsesByDateRange(LocalDateTime startDate, LocalDateTime endDate) {
        List<ChecklistResponseEntity> checklistResponses = this.checklistResponseRepository.findByCreatedAtBetween(startDate, endDate);
        return checklistResponses.stream().map(this::convertToDetailDto).collect(Collectors.toList());
    }

    @Cacheable(value={"checklistResponsesByDamPaged"}, key="#damId + '_' + #pageable.pageNumber + '_' + #pageable.pageSize", cacheManager="checklistCacheManager")
    public PagedChecklistResponseDTO<ChecklistResponseDetailDTO> findChecklistResponsesByDamIdPaged(Long damId, Pageable pageable) {
        this.damService.findById(damId);
        Page<ChecklistResponseEntity> page = this.checklistResponseRepository.findByDamIdOptimized(damId, pageable);
        List dtos = page.getContent().stream().map(this::convertToDetailDto).collect(Collectors.toList());
        return new PagedChecklistResponseDTO<ChecklistResponseDetailDTO>(dtos, page.getNumber(), page.getSize(), page.getTotalElements(), page.getTotalPages(), page.isLast(), page.isFirst());
    }

    @Cacheable(value={"checklistResponsesByUserPaged"}, key="#userId + '_' + #pageable.pageNumber + '_' + #pageable.pageSize", cacheManager="checklistCacheManager")
    public PagedChecklistResponseDTO<ChecklistResponseDetailDTO> findChecklistResponsesByUserIdPaged(Long userId, Pageable pageable) {
        Page<ChecklistResponseEntity> page = this.checklistResponseRepository.findByUserId(userId, pageable);
        List dtos = page.getContent().stream().map(this::convertToDetailDto).collect(Collectors.toList());
        return new PagedChecklistResponseDTO<ChecklistResponseDetailDTO>(dtos, page.getNumber(), page.getSize(), page.getTotalElements(), page.getTotalPages(), page.isLast(), page.isFirst());
    }

    @Cacheable(value={"checklistResponsesByDatePaged"}, key="#startDate.toString() + '_' + #endDate.toString() + '_' + #pageable.pageNumber + '_' + #pageable.pageSize", cacheManager="checklistCacheManager")
    public PagedChecklistResponseDTO<ChecklistResponseDetailDTO> findChecklistResponsesByDateRangePaged(LocalDateTime startDate, LocalDateTime endDate, Pageable pageable) {
        Page<ChecklistResponseEntity> page = this.checklistResponseRepository.findByCreatedAtBetween(startDate, endDate, pageable);
        List dtos = page.getContent().stream().map(this::convertToDetailDto).collect(Collectors.toList());
        return new PagedChecklistResponseDTO<ChecklistResponseDetailDTO>(dtos, page.getNumber(), page.getSize(), page.getTotalElements(), page.getTotalPages(), page.isLast(), page.isFirst());
    }

    @Cacheable(value={"allChecklistResponsesPaged"}, key="#pageable.pageNumber + '_' + #pageable.pageSize", cacheManager="checklistCacheManager")
    public PagedChecklistResponseDTO<ChecklistResponseDetailDTO> findAllChecklistResponsesPaged(Pageable pageable) {
        Page<ChecklistResponseEntity> page = this.checklistResponseRepository.findAll(pageable);
        List dtos = page.getContent().stream().map(this::convertToDetailDto).collect(Collectors.toList());
        return new PagedChecklistResponseDTO<ChecklistResponseDetailDTO>(dtos, page.getNumber(), page.getSize(), page.getTotalElements(), page.getTotalPages(), page.isLast(), page.isFirst());
    }

    @Cacheable(value={"damLastChecklist"}, key="#clientId", cacheManager="checklistCacheManager")
    public List<DamLastChecklistDTO> getLastChecklistDateByClient(Long clientId) {
        List<DamEntity> dams = this.damService.findDamsByClientId(clientId);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        ArrayList<DamLastChecklistDTO> result = new ArrayList<DamLastChecklistDTO>();
        for (DamEntity dam : dams) {
            List<ChecklistResponseEntity> responses = this.checklistResponseRepository.findByDamId(dam.getId());
            if (responses.isEmpty()) {
                result.add(new DamLastChecklistDTO(dam.getId(), dam.getName(), "Nenhuma inspe\u00e7\u00e3o realizada."));
                continue;
            }
            ChecklistResponseEntity last = responses.stream().max((a, b) -> a.getCreatedAt().compareTo(b.getCreatedAt())).orElse(null);
            String dateStr = last != null ? last.getCreatedAt().format(formatter) : "Nenhuma inspe\u00e7\u00e3o realizada.";
            result.add(new DamLastChecklistDTO(dam.getId(), dam.getName(), dateStr));
        }
        return result;
    }

    @Cacheable(value={"clientLatestDetailedChecklistResponses"}, key="#clientId + '_' + #limit", cacheManager="checklistCacheManager")
    public ClientDetailedChecklistResponsesDTO findLatestDetailedChecklistResponsesByClientId(Long clientId, int limit) {
        ClientEntity client = (ClientEntity)this.clientRepository.findById(clientId).orElseThrow(() -> new NotFoundException("Cliente n\u00e3o encontrado com ID: " + clientId));
        List<Long> responseIds = this.checklistResponseRepository.findLatestChecklistResponseIdsByClientIdAndLimit(clientId, limit);
        if (responseIds.isEmpty()) {
            return new ClientDetailedChecklistResponsesDTO(clientId, client.getName(), List.of());
        }
        ArrayList<ChecklistResponseEntity> responses = new ArrayList<ChecklistResponseEntity>();
        for (Long id2 : responseIds) {
            ChecklistResponseEntity response = this.checklistResponseRepository.findByIdWithFullDetails(id2).orElse(null);
            if (response == null) continue;
            responses.add(response);
        }
        HashMap<Long, ClientDetailedChecklistResponsesDTO.ChecklistWithDetailedResponsesDTO> checklistMap = new HashMap<Long, ClientDetailedChecklistResponsesDTO.ChecklistWithDetailedResponsesDTO>();
        for (ChecklistResponseEntity response : responses) {
            Long checklistId = response.getChecklistId();
            ClientDetailedChecklistResponsesDTO.ChecklistWithDetailedResponsesDTO checklistDto = checklistMap.computeIfAbsent(checklistId, id -> new ClientDetailedChecklistResponsesDTO.ChecklistWithDetailedResponsesDTO(checklistId, response.getChecklistName(), new ArrayList<ChecklistResponseDetailDTO>()));
            ChecklistResponseDetailDTO detailedDto = this.convertToDetailDto(response);
            checklistDto.getLatestResponses().add(detailedDto);
        }
        return new ClientDetailedChecklistResponsesDTO(clientId, client.getName(), new ArrayList<ClientDetailedChecklistResponsesDTO.ChecklistWithDetailedResponsesDTO>(checklistMap.values()));
    }

    @Generated
    public ChecklistResponseService(ChecklistResponseRepository checklistResponseRepository, QuestionnaireResponseRepository questionnaireResponseRepository, DamService damService, ClientRepository clientRepository) {
        this.checklistResponseRepository = checklistResponseRepository;
        this.questionnaireResponseRepository = questionnaireResponseRepository;
        this.damService = damService;
        this.clientRepository = clientRepository;
    }
}

