/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.geosegbar.entities.ClientEntity;
import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.UserEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.time.LocalDateTime;
import lombok.Generated;

@Entity
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
@Table(name="dam_permissions", uniqueConstraints={@UniqueConstraint(columnNames={"user_id", "dam_id", "client_id"})}, indexes={@Index(name="idx_dam_perm_user_id", columnList="user_id"), @Index(name="idx_dam_perm_dam_id", columnList="dam_id"), @Index(name="idx_dam_perm_client_id", columnList="client_id"), @Index(name="idx_dam_perm_access", columnList="has_access"), @Index(name="idx_dam_perm_created_at", columnList="created_at"), @Index(name="idx_dam_perm_created_by", columnList="created_by"), @Index(name="idx_dam_perm_updated_by", columnList="updated_by"), @Index(name="idx_dam_perm_user_access", columnList="user_id, has_access"), @Index(name="idx_dam_perm_client_access", columnList="client_id, has_access"), @Index(name="idx_dam_perm_dam_access", columnList="dam_id, has_access"), @Index(name="idx_dam_perm_user_client", columnList="user_id, client_id"), @Index(name="idx_dam_perm_user_dam", columnList="user_id, dam_id")})
public class DamPermissionEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne
    @JoinColumn(name="user_id", nullable=false)
    private UserEntity user;
    @ManyToOne
    @JoinColumn(name="dam_id", nullable=false)
    private DamEntity dam;
    @ManyToOne
    @JoinColumn(name="client_id", nullable=false)
    private ClientEntity client;
    @Column(name="has_access", nullable=false)
    private Boolean hasAccess = false;
    @Column(name="created_at")
    private LocalDateTime createdAt;
    @Column(name="updated_at")
    private LocalDateTime updatedAt;
    @ManyToOne
    @JoinColumn(name="created_by")
    private UserEntity createdBy;
    @ManyToOne
    @JoinColumn(name="updated_by")
    private UserEntity updatedBy;

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public UserEntity getUser() {
        return this.user;
    }

    @Generated
    public DamEntity getDam() {
        return this.dam;
    }

    @Generated
    public ClientEntity getClient() {
        return this.client;
    }

    @Generated
    public Boolean getHasAccess() {
        return this.hasAccess;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public UserEntity getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public UserEntity getUpdatedBy() {
        return this.updatedBy;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setUser(UserEntity user) {
        this.user = user;
    }

    @Generated
    public void setDam(DamEntity dam) {
        this.dam = dam;
    }

    @Generated
    public void setClient(ClientEntity client) {
        this.client = client;
    }

    @Generated
    public void setHasAccess(Boolean hasAccess) {
        this.hasAccess = hasAccess;
    }

    @Generated
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setCreatedBy(UserEntity createdBy) {
        this.createdBy = createdBy;
    }

    @Generated
    public void setUpdatedBy(UserEntity updatedBy) {
        this.updatedBy = updatedBy;
    }

    @Generated
    public DamPermissionEntity() {
    }

    @Generated
    public DamPermissionEntity(Long id, UserEntity user, DamEntity dam, ClientEntity client, Boolean hasAccess, LocalDateTime createdAt, LocalDateTime updatedAt, UserEntity createdBy, UserEntity updatedBy) {
        this.id = id;
        this.user = user;
        this.dam = dam;
        this.client = client;
        this.hasAccess = hasAccess;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.createdBy = createdBy;
        this.updatedBy = updatedBy;
    }
}

