/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.user.persistence.jpa;

import com.geosegbar.entities.UserEntity;
import jakarta.persistence.QueryHint;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface UserRepository
extends JpaRepository<UserEntity, Long> {
    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    @Query(value="SELECT u FROM UserEntity u LEFT JOIN FETCH u.clients c LEFT JOIN FETCH u.sex LEFT JOIN FETCH u.status LEFT JOIN FETCH u.role LEFT JOIN FETCH u.createdBy cb LEFT JOIN FETCH u.attributionsPermission LEFT JOIN FETCH u.documentationPermission LEFT JOIN FETCH u.instrumentationPermission LEFT JOIN FETCH u.routineInspectionPermission WHERE u.id = :id")
    public Optional<UserEntity> findByIdWithAllDetails(@Param(value="id") Long var1);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    @Query(value="SELECT u FROM UserEntity u LEFT JOIN FETCH u.clients c LEFT JOIN FETCH u.createdBy cb WHERE u.id = :id")
    public Optional<UserEntity> findByIdWithClients(@Param(value="id") Long var1);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    @Query(value="SELECT u FROM UserEntity u LEFT JOIN FETCH u.sex LEFT JOIN FETCH u.status LEFT JOIN FETCH u.role WHERE u.email = :email")
    public Optional<UserEntity> findByEmailWithBasicDetails(@Param(value="email") String var1);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    @Query(value="SELECT u FROM UserEntity u LEFT JOIN FETCH u.clients c LEFT JOIN FETCH u.sex LEFT JOIN FETCH u.status LEFT JOIN FETCH u.role LEFT JOIN FETCH u.createdBy cb ORDER BY u.id ASC")
    public List<UserEntity> findAllWithBasicDetails();

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    @Query(value="SELECT DISTINCT u FROM UserEntity u LEFT JOIN FETCH u.clients c LEFT JOIN FETCH u.sex LEFT JOIN FETCH u.status LEFT JOIN FETCH u.role LEFT JOIN FETCH u.createdBy cb WHERE (:roleId IS NULL OR u.role.id = :roleId) AND (:clientId IS NULL OR c.id = :clientId) AND (:statusId IS NULL OR u.status.id = :statusId) ORDER BY u.id ASC")
    public List<UserEntity> findByRoleAndClientWithDetails(@Param(value="roleId") Long var1, @Param(value="clientId") Long var2, @Param(value="statusId") Long var3);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    @Query(value="SELECT u FROM UserEntity u LEFT JOIN FETCH u.clients c LEFT JOIN FETCH u.sex LEFT JOIN FETCH u.status LEFT JOIN FETCH u.role LEFT JOIN FETCH u.createdBy cb WHERE u.createdBy.id = :createdById ORDER BY u.id ASC")
    public List<UserEntity> findByCreatedByIdWithDetails(@Param(value="createdById") Long var1);

    public List<UserEntity> findAllByOrderByIdAsc();

    public Optional<UserEntity> findByEmail(String var1);

    @Query(value="SELECT DISTINCT u FROM UserEntity u LEFT JOIN u.clients c WHERE (:roleId IS NULL OR u.role.id = :roleId) AND (:clientId IS NULL OR c.id = :clientId) AND (:statusId IS NULL OR u.status.id = :statusId)")
    public List<UserEntity> findByRoleAndClient(@Param(value="roleId") Long var1, @Param(value="clientId") Long var2, @Param(value="statusId") Long var3);

    public List<UserEntity> findByCreatedById(Long var1);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    @Query(value="SELECT u FROM UserEntity u LEFT JOIN FETCH u.clients c LEFT JOIN FETCH u.sex LEFT JOIN FETCH u.role WHERE u.email = :email")
    public Optional<UserEntity> findByEmailWithClientsAndDetails(@Param(value="email") String var1);

    public boolean existsByName(String var1);

    public boolean existsByEmail(String var1);

    public boolean existsByPhone(String var1);

    public boolean existsByEmailAndIdNot(String var1, Long var2);

    public boolean existsByPhoneAndIdNot(String var1, Long var2);
}

