/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.security_level.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.SecurityLevelEntity;
import com.geosegbar.infra.security_level.services.SecurityLevelService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/security-levels"})
public class SecurityLevelController {
    private final SecurityLevelService securityLevelService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<SecurityLevelEntity>>> getAllSecurityLevels() {
        List<SecurityLevelEntity> securityLevels = this.securityLevelService.findAll();
        WebResponseEntity<List<SecurityLevelEntity>> response = WebResponseEntity.success(securityLevels, "N\u00edveis de seguran\u00e7a obtidos com sucesso!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<SecurityLevelEntity>> getSecurityLevelById(@PathVariable Long id) {
        SecurityLevelEntity securityLevel = this.securityLevelService.findById(id);
        WebResponseEntity<SecurityLevelEntity> response = WebResponseEntity.success(securityLevel, "N\u00edvel de seguran\u00e7a obtido com sucesso!");
        return ResponseEntity.ok(response);
    }

    @PostMapping
    public ResponseEntity<WebResponseEntity<SecurityLevelEntity>> createSecurityLevel(@Valid @RequestBody SecurityLevelEntity securityLevel) {
        SecurityLevelEntity createdSecurityLevel = this.securityLevelService.save(securityLevel);
        WebResponseEntity<SecurityLevelEntity> response = WebResponseEntity.success(createdSecurityLevel, "N\u00edvel de seguran\u00e7a criado com sucesso!");
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<SecurityLevelEntity>> updateSecurityLevel(@PathVariable Long id, @Valid @RequestBody SecurityLevelEntity securityLevel) {
        securityLevel.setId(id);
        SecurityLevelEntity updatedSecurityLevel = this.securityLevelService.update(securityLevel);
        WebResponseEntity<SecurityLevelEntity> response = WebResponseEntity.success(updatedSecurityLevel, "N\u00edvel de seguran\u00e7a atualizado com sucesso!");
        return ResponseEntity.ok(response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteSecurityLevel(@PathVariable Long id) {
        this.securityLevelService.deleteById(id);
        WebResponseEntity<Object> response = WebResponseEntity.success(null, "N\u00edvel de seguran\u00e7a exclu\u00eddo com sucesso!");
        return ResponseEntity.ok(response);
    }

    @Generated
    public SecurityLevelController(SecurityLevelService securityLevelService) {
        this.securityLevelService = securityLevelService;
    }
}

