/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.risk_category.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.RiskCategoryEntity;
import com.geosegbar.infra.risk_category.services.RiskCategoryService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/risk-categories"})
public class RiskCategoryController {
    private final RiskCategoryService riskCategoryService;

    @GetMapping
    public ResponseEntity<WebResponseEntity<List<RiskCategoryEntity>>> getAllRiskCategories() {
        List<RiskCategoryEntity> riskCategories = this.riskCategoryService.findAll();
        WebResponseEntity<List<RiskCategoryEntity>> response = WebResponseEntity.success(riskCategories, "Categorias de risco obtidas com sucesso!");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<RiskCategoryEntity>> getRiskCategoryById(@PathVariable Long id) {
        RiskCategoryEntity riskCategory = this.riskCategoryService.findById(id);
        WebResponseEntity<RiskCategoryEntity> response = WebResponseEntity.success(riskCategory, "Categoria de risco obtida com sucesso!");
        return ResponseEntity.ok(response);
    }

    @PostMapping
    public ResponseEntity<WebResponseEntity<RiskCategoryEntity>> createRiskCategory(@Valid @RequestBody RiskCategoryEntity riskCategory) {
        RiskCategoryEntity createdRiskCategory = this.riskCategoryService.save(riskCategory);
        WebResponseEntity<RiskCategoryEntity> response = WebResponseEntity.success(createdRiskCategory, "Categoria de risco criada com sucesso!");
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<RiskCategoryEntity>> updateRiskCategory(@PathVariable Long id, @Valid @RequestBody RiskCategoryEntity riskCategory) {
        riskCategory.setId(id);
        RiskCategoryEntity updatedRiskCategory = this.riskCategoryService.update(riskCategory);
        WebResponseEntity<RiskCategoryEntity> response = WebResponseEntity.success(updatedRiskCategory, "Categoria de risco atualizada com sucesso!");
        return ResponseEntity.ok(response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteRiskCategory(@PathVariable Long id) {
        this.riskCategoryService.deleteById(id);
        WebResponseEntity<Object> response = WebResponseEntity.success(null, "Categoria de risco exclu\u00edda com sucesso!");
        return ResponseEntity.ok(response);
    }

    @Generated
    public RiskCategoryController(RiskCategoryService riskCategoryService) {
        this.riskCategoryService = riskCategoryService;
    }
}

