/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.psb.web;

import com.geosegbar.common.response.WebResponseEntity;
import com.geosegbar.entities.PSBFileEntity;
import com.geosegbar.entities.PSBFolderEntity;
import com.geosegbar.infra.psb.dtos.CreatePSBFolderRequest;
import com.geosegbar.infra.psb.services.PSBFileService;
import com.geosegbar.infra.psb.services.PSBFolderService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/psb"})
public class PSBController {
    private final PSBFolderService psbFolderService;
    private final PSBFileService psbFileService;

    @GetMapping(value={"/folders/dam/{damId}"})
    public ResponseEntity<WebResponseEntity<List<PSBFolderEntity>>> getFoldersByDamId(@PathVariable Long damId) {
        List<PSBFolderEntity> folders = this.psbFolderService.findAllByDamId(damId);
        WebResponseEntity<List<PSBFolderEntity>> response = WebResponseEntity.success(folders, "Pastas PSB obtidas com sucesso");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/folders/{id}"})
    public ResponseEntity<WebResponseEntity<PSBFolderEntity>> getFolderById(@PathVariable Long id) {
        PSBFolderEntity folder = this.psbFolderService.findById(id);
        WebResponseEntity<PSBFolderEntity> response = WebResponseEntity.success(folder, "Pasta PSB obtida com sucesso");
        return ResponseEntity.ok(response);
    }

    @PostMapping(value={"/folders"})
    public ResponseEntity<WebResponseEntity<PSBFolderEntity>> createFolder(@Valid @RequestBody CreatePSBFolderRequest request) {
        PSBFolderEntity folder = this.psbFolderService.create(request);
        WebResponseEntity<PSBFolderEntity> response = WebResponseEntity.success(folder, "Pasta PSB criada com sucesso");
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/folders/{id}"})
    public ResponseEntity<WebResponseEntity<PSBFolderEntity>> updateFolder(@PathVariable Long id, @Valid @RequestBody CreatePSBFolderRequest request) {
        PSBFolderEntity folder = this.psbFolderService.update(id, request);
        WebResponseEntity<PSBFolderEntity> response = WebResponseEntity.success(folder, "Pasta PSB atualizada com sucesso");
        return ResponseEntity.ok(response);
    }

    @DeleteMapping(value={"/folders/{id}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteFolder(@PathVariable Long id) {
        this.psbFolderService.delete(id);
        WebResponseEntity<Object> response = WebResponseEntity.success(null, "Pasta PSB exclu\u00edda com sucesso");
        return ResponseEntity.ok(response);
    }

    @GetMapping(value={"/files/folder/{folderId}"})
    public ResponseEntity<WebResponseEntity<List<PSBFileEntity>>> getFilesByFolderId(@PathVariable Long folderId) {
        List<PSBFileEntity> files = this.psbFileService.findByFolderId(folderId);
        WebResponseEntity<List<PSBFileEntity>> response = WebResponseEntity.success(files, "Arquivos PSB obtidos com sucesso");
        return ResponseEntity.ok(response);
    }

    @PostMapping(value={"/files/upload/{folderId}"})
    public ResponseEntity<WebResponseEntity<PSBFileEntity>> uploadFile(@PathVariable Long folderId, @RequestParam(value="file") MultipartFile file, @RequestParam(value="uploadedById") Long uploadedById) {
        PSBFileEntity psbFile = this.psbFileService.uploadFile(folderId, file, uploadedById);
        WebResponseEntity<PSBFileEntity> response = WebResponseEntity.success(psbFile, "Arquivo PSB enviado com sucesso");
        return new ResponseEntity(response, (HttpStatusCode)HttpStatus.CREATED);
    }

    @GetMapping(value={"/files/download/{fileId}"})
    public ResponseEntity<Resource> downloadFile(@PathVariable Long fileId) {
        PSBFileEntity file = this.psbFileService.findById(fileId);
        Resource resource = this.psbFileService.downloadFile(fileId);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)file.getContentType())).header("Content-Disposition", new String[]{"attachment; filename=\"" + file.getOriginalFilename() + "\""})).body((Object)resource);
    }

    @DeleteMapping(value={"/files/{fileId}"})
    public ResponseEntity<WebResponseEntity<Void>> deleteFile(@PathVariable Long fileId) {
        this.psbFileService.deleteFile(fileId);
        WebResponseEntity<Object> response = WebResponseEntity.success(null, "Arquivo PSB exclu\u00eddo com sucesso");
        return ResponseEntity.ok(response);
    }

    @Generated
    public PSBController(PSBFolderService psbFolderService, PSBFileService psbFileService) {
        this.psbFolderService = psbFolderService;
        this.psbFileService = psbFileService;
    }
}

