/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.option.services;

import com.geosegbar.entities.OptionEntity;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.option.persistence.jpa.OptionRepository;
import jakarta.annotation.PostConstruct;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class OptionService {
    private final OptionRepository optionRepository;

    @PostConstruct
    @Transactional
    public void initializeDefaultOptions() {
        this.createIfNotExists("NE", "N\u00e3o Existe", 1);
        this.createIfNotExists("PV", "Primeira Vez", 2);
        this.createIfNotExists("AU", "Aumentou", 3);
        this.createIfNotExists("DM", "Diminuiu", 4);
        this.createIfNotExists("DS", "Desapareceu", 5);
        this.createIfNotExists("PC", "Permaneceu Constante", 6);
        this.createIfNotExists("NI", "N\u00e3o Inspecionado", 7);
    }

    private void createIfNotExists(String label, String value, Integer orderIndex) {
        Optional<OptionEntity> existingOption = this.optionRepository.findByLabel(label);
        if (existingOption.isEmpty()) {
            OptionEntity option = new OptionEntity();
            option.setLabel(label);
            option.setValue(value);
            option.setOrderIndex(orderIndex);
            this.optionRepository.save(option);
        }
    }

    @Transactional
    public void deleteById(Long id) {
        this.optionRepository.findById(id).orElseThrow(() -> new NotFoundException("Op\u00e7\u00e3o n\u00e3o encontrada para exclus\u00e3o!"));
        this.optionRepository.deleteById(id);
    }

    @Transactional
    public OptionEntity save(OptionEntity option) {
        return (OptionEntity)this.optionRepository.save(option);
    }

    @Transactional
    public OptionEntity update(OptionEntity option) {
        this.optionRepository.findById(option.getId()).orElseThrow(() -> new NotFoundException("Op\u00e7\u00e3o n\u00e3o encontrada para atualiza\u00e7\u00e3o!"));
        return (OptionEntity)this.optionRepository.save(option);
    }

    public OptionEntity findById(Long id) {
        return (OptionEntity)this.optionRepository.findById(id).orElseThrow(() -> new NotFoundException("Op\u00e7\u00e3o n\u00e3o encontrada!"));
    }

    public List<OptionEntity> findAll() {
        return this.optionRepository.findAllByOrderByOrderIndexAsc();
    }

    @Generated
    public OptionService(OptionRepository optionRepository) {
        this.optionRepository = optionRepository;
    }
}

