/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.measurement_unit.services;

import com.geosegbar.entities.MeasurementUnitEntity;
import com.geosegbar.exceptions.DuplicateResourceException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.measurement_unit.persistence.jpa.MeasurementUnitRepository;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MeasurementUnitService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MeasurementUnitService.class);
    private final MeasurementUnitRepository measurementUnitRepository;

    @PostConstruct
    public void initDefaultUnits() {
        if (this.measurementUnitRepository.count() == 0L) {
            this.createDefaultUnit("Metros", "M");
            this.createDefaultUnit("Cent\u00edmetros", "CM");
            this.createDefaultUnit("Mil\u00edmetros", "MM");
            this.createDefaultUnit("Metros c\u00fabicos", "M\u00b3");
            this.createDefaultUnit("Metros c\u00fabicos por segundo", "M\u00b3/S");
            this.createDefaultUnit("Litros por segundo", "L/S");
            this.createDefaultUnit("Quilopascal", "KPA");
            this.createDefaultUnit("Megapascal", "MPA");
            this.createDefaultUnit("Graus Celsius", "\u00b0C");
            this.createDefaultUnit("Percentual", "%");
            this.createDefaultUnit("Metros por segundo", "M/S");
            this.createDefaultUnit("Graus", "\u00b0");
        }
    }

    private void createDefaultUnit(String name, String acronym) {
        MeasurementUnitEntity unit = new MeasurementUnitEntity();
        unit.setName(name);
        unit.setAcronym(acronym);
        this.measurementUnitRepository.save(unit);
    }

    public List<MeasurementUnitEntity> findAll() {
        return this.measurementUnitRepository.findAllByOrderByNameAsc();
    }

    public MeasurementUnitEntity findById(Long id) {
        return (MeasurementUnitEntity)this.measurementUnitRepository.findById(id).orElseThrow(() -> new NotFoundException("Unidade de medida n\u00e3o encontrada com ID: " + id));
    }

    public Optional<MeasurementUnitEntity> findByName(String name) {
        return this.measurementUnitRepository.findByName(name);
    }

    public Optional<MeasurementUnitEntity> findByAcronym(String acronym) {
        return this.measurementUnitRepository.findByAcronym(acronym);
    }

    @Transactional
    public MeasurementUnitEntity create(MeasurementUnitEntity measurementUnit) {
        measurementUnit.setName(this.formatName(measurementUnit.getName()));
        measurementUnit.setAcronym(this.formatAcronym(measurementUnit.getAcronym()));
        if (this.measurementUnitRepository.existsByName(measurementUnit.getName())) {
            throw new DuplicateResourceException("Unidade de medida com nome '" + measurementUnit.getName() + "' j\u00e1 existe");
        }
        if (this.measurementUnitRepository.existsByAcronym(measurementUnit.getAcronym())) {
            throw new DuplicateResourceException("Unidade de medida com sigla '" + measurementUnit.getAcronym() + "' j\u00e1 existe");
        }
        MeasurementUnitEntity savedUnit = (MeasurementUnitEntity)this.measurementUnitRepository.save(measurementUnit);
        return savedUnit;
    }

    @Transactional
    public MeasurementUnitEntity update(Long id, MeasurementUnitEntity measurementUnit) {
        MeasurementUnitEntity existingUnit = this.findById(id);
        String normalizedName = this.formatName(measurementUnit.getName());
        String normalizedAcronym = this.formatAcronym(measurementUnit.getAcronym());
        if (this.measurementUnitRepository.existsByNameAndIdNot(normalizedName, id)) {
            throw new DuplicateResourceException("Unidade de medida com nome '" + normalizedName + "' j\u00e1 existe");
        }
        if (this.measurementUnitRepository.existsByAcronymAndIdNot(normalizedAcronym, id)) {
            throw new DuplicateResourceException("Unidade de medida com sigla '" + normalizedAcronym + "' j\u00e1 existe");
        }
        existingUnit.setName(normalizedName);
        existingUnit.setAcronym(normalizedAcronym);
        MeasurementUnitEntity updatedUnit = (MeasurementUnitEntity)this.measurementUnitRepository.save(existingUnit);
        return updatedUnit;
    }

    @Transactional
    public void delete(Long id) {
        MeasurementUnitEntity measurementUnit = this.findById(id);
        this.measurementUnitRepository.delete(measurementUnit);
    }

    private String formatName(String name) {
        if (name == null || name.isBlank()) {
            return name;
        }
        String trimmed = name.trim();
        return trimmed.substring(0, 1).toUpperCase() + trimmed.substring(1).toLowerCase();
    }

    private String formatAcronym(String acronym) {
        return acronym == null ? null : acronym.trim().toUpperCase();
    }

    @Generated
    public MeasurementUnitService(MeasurementUnitRepository measurementUnitRepository) {
        this.measurementUnitRepository = measurementUnitRepository;
    }
}

