/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.instrument_tabulate_pattern_folder.services;

import com.geosegbar.common.utils.InstrumentTabulatePatternMapper;
import com.geosegbar.entities.DamEntity;
import com.geosegbar.entities.InstrumentTabulatePatternEntity;
import com.geosegbar.entities.InstrumentTabulatePatternFolder;
import com.geosegbar.exceptions.DuplicateResourceException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.dam.services.DamService;
import com.geosegbar.infra.instrument_tabulate_pattern.dtos.TabulatePatternResponseDTO;
import com.geosegbar.infra.instrument_tabulate_pattern.persistence.jpa.InstrumentTabulatePatternRepository;
import com.geosegbar.infra.instrument_tabulate_pattern_folder.dtos.CreateTabulateFolderRequestDTO;
import com.geosegbar.infra.instrument_tabulate_pattern_folder.dtos.DamTabulateFoldersWithPatternsDetailResponseDTO;
import com.geosegbar.infra.instrument_tabulate_pattern_folder.dtos.TabulateFolderResponseDTO;
import com.geosegbar.infra.instrument_tabulate_pattern_folder.dtos.TabulateFolderWithPatternsDetailResponseDTO;
import com.geosegbar.infra.instrument_tabulate_pattern_folder.persistence.jpa.InstrumentTabulatePatternFolderRepository;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InstrumentTabulatePatternFolderService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstrumentTabulatePatternFolderService.class);
    private final InstrumentTabulatePatternFolderRepository folderRepository;
    private final InstrumentTabulatePatternRepository patternRepository;
    private final DamService damService;
    private final InstrumentTabulatePatternMapper mapper;

    @Transactional
    @CacheEvict(value={"tabulateFolderWithPatterns", "damTabulateFoldersWithPatterns", "tabulatePatternsByDam"}, allEntries=true, cacheManager="instrumentTabulateCacheManager")
    public TabulateFolderResponseDTO create(CreateTabulateFolderRequestDTO request) {
        if (this.folderRepository.existsByNameAndDamId(request.getName(), request.getDamId())) {
            throw new DuplicateResourceException("J\u00e1 existe uma pasta de padr\u00f5es de tabela com o nome '" + request.getName() + "' nesta barragem!");
        }
        DamEntity dam = this.damService.findById(request.getDamId());
        InstrumentTabulatePatternFolder folder = new InstrumentTabulatePatternFolder();
        folder.setName(request.getName());
        folder.setDam(dam);
        folder = (InstrumentTabulatePatternFolder)this.folderRepository.save(folder);
        log.info("Pasta de padr\u00f5es de tabela criada: id={}, name={}, damId={}", new Object[]{folder.getId(), folder.getName(), dam.getId()});
        return this.mapToResponseDTO(folder);
    }

    @Transactional(readOnly=true)
    @Cacheable(value={"damTabulateFoldersWithPatterns"}, key="#damId", cacheManager="instrumentTabulateCacheManager")
    public DamTabulateFoldersWithPatternsDetailResponseDTO findFoldersWithPatternsDetailsByDam(Long damId) {
        DamEntity dam = this.damService.findById(damId);
        List<InstrumentTabulatePatternFolder> folders = this.folderRepository.findByDamIdWithDamDetails(damId);
        List<InstrumentTabulatePatternEntity> patternsInFolders = this.patternRepository.findByFolderDamIdWithAllDetails(damId);
        List<InstrumentTabulatePatternEntity> patternsWithoutFolder = this.patternRepository.findByDamIdWithoutFolderWithAllDetails(damId);
        Map<Long, List<InstrumentTabulatePatternEntity>> patternsByFolder = patternsInFolders.stream().collect(Collectors.groupingBy(p -> p.getFolder().getId()));
        List<TabulateFolderWithPatternsDetailResponseDTO> folderDTOs = folders.stream().map(folder -> {
            List folderPatterns = patternsByFolder.getOrDefault(folder.getId(), List.of());
            List<TabulatePatternResponseDTO> patternDTOs = folderPatterns.stream().map(this.mapper::mapToResponseDTO).collect(Collectors.toList());
            TabulateFolderWithPatternsDetailResponseDTO folderDTO = new TabulateFolderWithPatternsDetailResponseDTO();
            folderDTO.setId(folder.getId());
            folderDTO.setName(folder.getName());
            if (folder.getDam() != null) {
                folderDTO.setDam(new TabulateFolderWithPatternsDetailResponseDTO.DamDetailDTO(folder.getDam().getId(), folder.getDam().getName(), folder.getDam().getCity(), folder.getDam().getState()));
            }
            folderDTO.setPatterns(patternDTOs);
            return folderDTO;
        }).collect(Collectors.toList());
        List<TabulatePatternResponseDTO> patternsWithoutFolderDTOs = patternsWithoutFolder.stream().map(this.mapper::mapToResponseDTO).collect(Collectors.toList());
        DamTabulateFoldersWithPatternsDetailResponseDTO responseDTO = new DamTabulateFoldersWithPatternsDetailResponseDTO();
        responseDTO.setDamId(dam.getId());
        responseDTO.setDamName(dam.getName());
        responseDTO.setDamCity(dam.getCity());
        responseDTO.setDamState(dam.getState());
        responseDTO.setFolders(folderDTOs);
        responseDTO.setPatternsWithoutFolder(patternsWithoutFolderDTOs);
        int totalPatternsInFolders = folderDTOs.stream().mapToInt(f -> f.getPatterns().size()).sum();
        log.debug("Dam {} - Folders: {}, Patterns em folders: {}, Patterns sem folder: {}, Total patterns: {}", new Object[]{damId, folderDTOs.size(), totalPatternsInFolders, patternsWithoutFolderDTOs.size(), totalPatternsInFolders + patternsWithoutFolderDTOs.size()});
        return responseDTO;
    }

    @Transactional
    @CacheEvict(value={"tabulateFolderWithPatterns", "damTabulateFoldersWithPatterns", "tabulatePatternsByDam", "tabulatePatternsByFolder"}, allEntries=true, cacheManager="instrumentTabulateCacheManager")
    public void delete(Long folderId) {
        InstrumentTabulatePatternFolder folder = this.findById(folderId);
        List<InstrumentTabulatePatternEntity> patterns = this.patternRepository.findByFolderId(folderId);
        for (InstrumentTabulatePatternEntity pattern : patterns) {
            pattern.setFolder(null);
        }
        if (!patterns.isEmpty()) {
            this.patternRepository.saveAll(patterns);
            log.info("Removida refer\u00eancia da pasta de {} padr\u00f5es de tabela", (Object)patterns.size());
        }
        this.folderRepository.delete(folder);
        log.info("Pasta de padr\u00f5es de tabela exclu\u00edda: id={}, name={}, padr\u00f5es afetados={}", new Object[]{folderId, folder.getName(), patterns.size()});
    }

    public TabulateFolderResponseDTO findByIdSimple(Long folderId) {
        InstrumentTabulatePatternFolder folder = this.findById(folderId);
        return this.mapToResponseDTO(folder);
    }

    @Transactional
    @CacheEvict(value={"tabulateFolderWithPatterns", "damTabulateFoldersWithPatterns"}, allEntries=true, cacheManager="instrumentTabulateCacheManager")
    public TabulateFolderResponseDTO updateFolderName(Long folderId, String newName) {
        InstrumentTabulatePatternFolder folder = this.findById(folderId);
        if (this.folderRepository.existsByNameAndDamId(newName, folder.getDam().getId())) {
            throw new DuplicateResourceException("J\u00e1 existe uma pasta de padr\u00f5es de tabela com o nome '" + newName + "' nesta barragem!");
        }
        folder.setName(newName);
        folder = (InstrumentTabulatePatternFolder)this.folderRepository.save(folder);
        return this.mapToResponseDTO(folder);
    }

    public InstrumentTabulatePatternFolder findById(Long folderId) {
        return (InstrumentTabulatePatternFolder)this.folderRepository.findById(folderId).orElseThrow(() -> new NotFoundException("Pasta de padr\u00f5es de tabela n\u00e3o encontrada com ID: " + folderId));
    }

    @Cacheable(value={"tabulateFoldersByDam"}, key="#damId", cacheManager="instrumentTabulateCacheManager")
    public List<TabulateFolderResponseDTO> findByDamId(Long damId) {
        this.damService.findById(damId);
        List<InstrumentTabulatePatternFolder> folders = this.folderRepository.findByDamIdWithDamDetails(damId);
        return folders.stream().map(this::mapToResponseDTO).toList();
    }

    private TabulateFolderResponseDTO mapToResponseDTO(InstrumentTabulatePatternFolder folder) {
        TabulateFolderResponseDTO dto = new TabulateFolderResponseDTO();
        dto.setId(folder.getId());
        dto.setName(folder.getName());
        if (folder.getDam() != null) {
            dto.setDam(new TabulateFolderResponseDTO.DamSummaryDTO(folder.getDam().getId(), folder.getDam().getName()));
        }
        return dto;
    }

    @Generated
    public InstrumentTabulatePatternFolderService(InstrumentTabulatePatternFolderRepository folderRepository, InstrumentTabulatePatternRepository patternRepository, DamService damService, InstrumentTabulatePatternMapper mapper) {
        this.folderRepository = folderRepository;
        this.patternRepository = patternRepository;
        this.damService = damService;
        this.mapper = mapper;
    }
}

