/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.infra.answer.services;

import com.geosegbar.common.enums.TypeQuestionEnum;
import com.geosegbar.entities.AnswerEntity;
import com.geosegbar.entities.QuestionEntity;
import com.geosegbar.exceptions.InvalidInputException;
import com.geosegbar.exceptions.NotFoundException;
import com.geosegbar.infra.answer.persistence.jpa.AnswerRepository;
import jakarta.transaction.Transactional;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class AnswerService {
    private final AnswerRepository answerRepository;

    @Transactional
    public void deleteById(Long id) {
        this.answerRepository.findById(id).orElseThrow(() -> new NotFoundException("Resposta n\u00e3o encontrada para exclus\u00e3o!"));
        this.answerRepository.deleteById(id);
    }

    @Transactional
    public AnswerEntity save(AnswerEntity answer) {
        this.validateAnswerByType(answer);
        return (AnswerEntity)this.answerRepository.save(answer);
    }

    @Transactional
    public AnswerEntity update(AnswerEntity answer) {
        this.answerRepository.findById(answer.getId()).orElseThrow(() -> new NotFoundException("Resposta n\u00e3o encontrada para atualiza\u00e7\u00e3o!"));
        this.validateAnswerByType(answer);
        return (AnswerEntity)this.answerRepository.save(answer);
    }

    public AnswerEntity findById(Long id) {
        return (AnswerEntity)this.answerRepository.findById(id).orElseThrow(() -> new NotFoundException("Resposta n\u00e3o encontrada!"));
    }

    public List<AnswerEntity> findAll() {
        return this.answerRepository.findAll();
    }

    private void validateAnswerByType(AnswerEntity answer) {
        QuestionEntity question = answer.getQuestion();
        if (question == null) {
            throw new InvalidInputException("A resposta deve estar associada a uma pergunta");
        }
        if (TypeQuestionEnum.TEXT.equals((Object)question.getType())) {
            if (answer.getComment() == null || answer.getComment().trim().isEmpty()) {
                throw new InvalidInputException("Respostas para perguntas do tipo TEXTO devem ter o campo de texto preenchido!");
            }
            if (answer.getSelectedOptions() != null && !answer.getSelectedOptions().isEmpty()) {
                throw new InvalidInputException("Respostas para perguntas do tipo TEXTO n\u00e3o devem ter op\u00e7\u00f5es selecionadas!");
            }
        } else if (TypeQuestionEnum.CHECKBOX.equals((Object)question.getType()) && (answer.getSelectedOptions() == null || answer.getSelectedOptions().isEmpty())) {
            throw new InvalidInputException("Respostas para perguntas do tipo CHECKBOX devem ter pelo menos uma op\u00e7\u00e3o selecionada!");
        }
    }

    @Generated
    public AnswerService(AnswerRepository answerRepository) {
        this.answerRepository = answerRepository;
    }
}

