/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.geosegbar.entities.PSBFolderEntity;
import com.geosegbar.entities.UserEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.UUID;
import lombok.Generated;

@Entity
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
@Table(name="share_folders", indexes={@Index(name="idx_share_folder_psb_folder", columnList="psb_folder_id"), @Index(name="idx_share_folder_token", columnList="token", unique=true)})
public class ShareFolderEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull(message="A pasta PSB \u00e9 obrigat\u00f3ria")
    @ManyToOne
    @JoinColumn(name="psb_folder_id", nullable=false)
    @JsonIgnoreProperties(value={"shareLinks", "files", "dam", "createdBy"})
    private @NotNull(message="A pasta PSB \u00e9 obrigat\u00f3ria") PSBFolderEntity psbFolder;
    @NotNull(message="O usu\u00e1rio que compartilha \u00e9 obrigat\u00f3rio")
    @ManyToOne
    @JoinColumn(name="shared_by_id", nullable=false)
    @JsonIgnoreProperties(value={"psbFoldersCreated", "psbFilesUploaded", "sharedFolders"})
    private @NotNull(message="O usu\u00e1rio que compartilha \u00e9 obrigat\u00f3rio") UserEntity sharedBy;
    @NotBlank(message="O email do destinat\u00e1rio \u00e9 obrigat\u00f3rio")
    @Email(message="Email inv\u00e1lido")
    @Column(name="shared_with_email", nullable=false)
    private @NotBlank(message="O email do destinat\u00e1rio \u00e9 obrigat\u00f3rio") @Email(message="Email inv\u00e1lido") String sharedWithEmail;
    @Column(name="access_count", nullable=false)
    private Integer accessCount = 0;
    @Column(name="created_at", nullable=false)
    private LocalDateTime createdAt;
    @Column(name="last_accessed_at")
    private LocalDateTime lastAccessedAt;
    @Column(name="expires_at", nullable=true)
    private LocalDateTime expiresAt;
    @Column(name="token", nullable=false, unique=true, length=36)
    private String token;

    @PrePersist
    protected void onCreate() {
        this.createdAt = LocalDateTime.now();
        if (this.token == null) {
            this.token = UUID.randomUUID().toString();
        }
    }

    public void incrementAccessCount() {
        Integer n = this.accessCount;
        this.accessCount = this.accessCount + 1;
        this.lastAccessedAt = LocalDateTime.now();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public PSBFolderEntity getPsbFolder() {
        return this.psbFolder;
    }

    @Generated
    public UserEntity getSharedBy() {
        return this.sharedBy;
    }

    @Generated
    public String getSharedWithEmail() {
        return this.sharedWithEmail;
    }

    @Generated
    public Integer getAccessCount() {
        return this.accessCount;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public LocalDateTime getLastAccessedAt() {
        return this.lastAccessedAt;
    }

    @Generated
    public LocalDateTime getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnoreProperties(value={"shareLinks", "files", "dam", "createdBy"})
    @Generated
    public void setPsbFolder(PSBFolderEntity psbFolder) {
        this.psbFolder = psbFolder;
    }

    @JsonIgnoreProperties(value={"psbFoldersCreated", "psbFilesUploaded", "sharedFolders"})
    @Generated
    public void setSharedBy(UserEntity sharedBy) {
        this.sharedBy = sharedBy;
    }

    @Generated
    public void setSharedWithEmail(String sharedWithEmail) {
        this.sharedWithEmail = sharedWithEmail;
    }

    @Generated
    public void setAccessCount(Integer accessCount) {
        this.accessCount = accessCount;
    }

    @Generated
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setLastAccessedAt(LocalDateTime lastAccessedAt) {
        this.lastAccessedAt = lastAccessedAt;
    }

    @Generated
    public void setExpiresAt(LocalDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @Generated
    public ShareFolderEntity() {
    }

    @Generated
    public ShareFolderEntity(Long id, PSBFolderEntity psbFolder, UserEntity sharedBy, String sharedWithEmail, Integer accessCount, LocalDateTime createdAt, LocalDateTime lastAccessedAt, LocalDateTime expiresAt, String token) {
        this.id = id;
        this.psbFolder = psbFolder;
        this.sharedBy = sharedBy;
        this.sharedWithEmail = sharedWithEmail;
        this.accessCount = accessCount;
        this.createdAt = createdAt;
        this.lastAccessedAt = lastAccessedAt;
        this.expiresAt = expiresAt;
        this.token = token;
    }
}

