/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.geosegbar.common.enums.LimitStatusEnum;
import com.geosegbar.entities.InstrumentEntity;
import com.geosegbar.entities.OutputEntity;
import com.geosegbar.entities.ReadingInputValueEntity;
import com.geosegbar.entities.UserEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

@Entity
@Table(name="reading", indexes={@Index(name="idx_reading_instrument_date_hour", columnList="instrument_id, date DESC, hour DESC"), @Index(name="idx_reading_instrument_active_date_hour", columnList="instrument_id, active, date DESC, hour DESC"), @Index(name="idx_reading_output_active_date_hour", columnList="output_id, active, date DESC, hour DESC"), @Index(name="idx_reading_instrument_output_active", columnList="instrument_id, output_id, active"), @Index(name="idx_reading_date_hour_status", columnList="date DESC, hour DESC, limit_status"), @Index(name="idx_reading_user_date", columnList="user_id, date DESC"), @Index(name="idx_reading_active", columnList="active"), @Index(name="idx_reading_limit_status", columnList="limit_status"), @Index(name="idx_reading_instrument_limit", columnList="instrument_id, limit_status"), @Index(name="idx_reading_date_range", columnList="date"), @Index(name="idx_reading_date_instrument_status", columnList="date DESC, instrument_id, limit_status"), @Index(name="idx_reading_instrument_date", columnList="instrument_id, date DESC"), @Index(name="idx_reading_output_date", columnList="output_id, date DESC"), @Index(name="idx_reading_user_instrument", columnList="user_id, instrument_id"), @Index(name="idx_reading_date_time_combined", columnList="date DESC, hour DESC"), @Index(name="idx_reading_instrument_value", columnList="instrument_id, calculated_value"), @Index(name="idx_reading_output_value", columnList="output_id, calculated_value"), @Index(name="idx_reading_active_date", columnList="active, date DESC"), @Index(name="idx_reading_status_date", columnList="limit_status, date DESC"), @Index(name="idx_reading_instrument_output_date", columnList="instrument_id, output_id, date DESC"), @Index(name="idx_reading_user_active_date", columnList="user_id, active, date DESC")})
public class ReadingEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull(message="Data da leitura \u00e9 obrigat\u00f3ria!")
    @Column(nullable=false)
    private @NotNull(message="Data da leitura \u00e9 obrigat\u00f3ria!") LocalDate date;
    @NotNull(message="Hora da leitura \u00e9 obrigat\u00f3ria!")
    @Column(nullable=false)
    private @NotNull(message="Hora da leitura \u00e9 obrigat\u00f3ria!") LocalTime hour;
    @Column(nullable=false)
    private Double calculatedValue;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private LimitStatusEnum limitStatus;
    @Column(nullable=false)
    private Boolean active;
    @Column(columnDefinition="TEXT")
    private String comment;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id")
    @JsonIgnoreProperties(value={"readings", "password", "damPermissions", "createdUsers", "psbFoldersCreated", "psbFilesUploaded", "sharedFolders", "attributionsPermission", "documentationPermission", "instrumentationPermission", "routineInspectionPermission"})
    private UserEntity user;
    @ManyToOne
    @JoinColumn(name="instrument_id", nullable=false)
    @JsonIgnoreProperties(value={"readings", "inputs", "outputs", "constants", "statisticalLimit", "deterministicLimit"})
    private InstrumentEntity instrument;
    @ManyToOne
    @JoinColumn(name="output_id", nullable=false)
    @JsonIgnoreProperties(value={"instrument"})
    private OutputEntity output;
    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinTable(name="reading_input_value_mapping", joinColumns={@JoinColumn(name="reading_id")}, inverseJoinColumns={@JoinColumn(name="input_value_id")}, indexes={@Index(name="idx_rivm_reading", columnList="reading_id"), @Index(name="idx_rivm_input_value", columnList="input_value_id")})
    @JsonIgnoreProperties(value={"readings"})
    private Set<ReadingInputValueEntity> inputValues = new HashSet<ReadingInputValueEntity>();

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public LocalDate getDate() {
        return this.date;
    }

    @Generated
    public LocalTime getHour() {
        return this.hour;
    }

    @Generated
    public Double getCalculatedValue() {
        return this.calculatedValue;
    }

    @Generated
    public LimitStatusEnum getLimitStatus() {
        return this.limitStatus;
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public UserEntity getUser() {
        return this.user;
    }

    @Generated
    public InstrumentEntity getInstrument() {
        return this.instrument;
    }

    @Generated
    public OutputEntity getOutput() {
        return this.output;
    }

    @Generated
    public Set<ReadingInputValueEntity> getInputValues() {
        return this.inputValues;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDate(LocalDate date) {
        this.date = date;
    }

    @Generated
    public void setHour(LocalTime hour) {
        this.hour = hour;
    }

    @Generated
    public void setCalculatedValue(Double calculatedValue) {
        this.calculatedValue = calculatedValue;
    }

    @Generated
    public void setLimitStatus(LimitStatusEnum limitStatus) {
        this.limitStatus = limitStatus;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @JsonIgnoreProperties(value={"readings", "password", "damPermissions", "createdUsers", "psbFoldersCreated", "psbFilesUploaded", "sharedFolders", "attributionsPermission", "documentationPermission", "instrumentationPermission", "routineInspectionPermission"})
    @Generated
    public void setUser(UserEntity user) {
        this.user = user;
    }

    @JsonIgnoreProperties(value={"readings", "inputs", "outputs", "constants", "statisticalLimit", "deterministicLimit"})
    @Generated
    public void setInstrument(InstrumentEntity instrument) {
        this.instrument = instrument;
    }

    @JsonIgnoreProperties(value={"instrument"})
    @Generated
    public void setOutput(OutputEntity output) {
        this.output = output;
    }

    @JsonIgnoreProperties(value={"readings"})
    @Generated
    public void setInputValues(Set<ReadingInputValueEntity> inputValues) {
        this.inputValues = inputValues;
    }

    @Generated
    public ReadingEntity() {
    }

    @Generated
    public ReadingEntity(Long id, LocalDate date, LocalTime hour, Double calculatedValue, LimitStatusEnum limitStatus, Boolean active, String comment, UserEntity user, InstrumentEntity instrument, OutputEntity output, Set<ReadingInputValueEntity> inputValues) {
        this.id = id;
        this.date = date;
        this.hour = hour;
        this.calculatedValue = calculatedValue;
        this.limitStatus = limitStatus;
        this.active = active;
        this.comment = comment;
        this.user = user;
        this.instrument = instrument;
        this.output = output;
        this.inputValues = inputValues;
    }
}

