/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.geosegbar.entities.DeterministicLimitEntity;
import com.geosegbar.entities.InstrumentEntity;
import com.geosegbar.entities.MeasurementUnitEntity;
import com.geosegbar.entities.StatisticalLimitEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;

@Entity
@Table(name="output", indexes={@Index(name="idx_output_instrument_active", columnList="instrument_id, active"), @Index(name="idx_output_acronym", columnList="acronym"), @Index(name="idx_output_instrument_acronym", columnList="instrument_id, acronym"), @Index(name="idx_output_active", columnList="active"), @Index(name="idx_output_measurement_unit", columnList="measurement_unit_id, instrument_id")})
public class OutputEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotBlank(message="Sigla do Output \u00e9 obrigat\u00f3rio!")
    @Column(nullable=false)
    private @NotBlank(message="Sigla do Output \u00e9 obrigat\u00f3rio!") String acronym;
    @NotBlank(message="Nome do Output \u00e9 obrigat\u00f3rio!")
    @Column(nullable=false)
    private @NotBlank(message="Nome do Output \u00e9 obrigat\u00f3rio!") String name;
    @Column(nullable=false, columnDefinition="TEXT")
    private String equation;
    @NotNull(message="Precis\u00e3o do Output \u00e9 obrigat\u00f3ria!")
    @Column(nullable=false)
    private @NotNull(message="Precis\u00e3o do Output \u00e9 obrigat\u00f3ria!") Integer precision;
    @Column(nullable=false)
    private Boolean active = true;
    @OneToOne(mappedBy="output", cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonIgnoreProperties(value={"output"})
    private StatisticalLimitEntity statisticalLimit;
    @OneToOne(mappedBy="output", cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonIgnoreProperties(value={"output"})
    private DeterministicLimitEntity deterministicLimit;
    @ManyToOne
    @JoinColumn(name="measurement_unit_id", nullable=false)
    private MeasurementUnitEntity measurementUnit;
    @ManyToOne
    @JoinColumn(name="instrument_id", nullable=false)
    @JsonIgnoreProperties(value={"outputs"})
    private InstrumentEntity instrument;

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getAcronym() {
        return this.acronym;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getEquation() {
        return this.equation;
    }

    @Generated
    public Integer getPrecision() {
        return this.precision;
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public StatisticalLimitEntity getStatisticalLimit() {
        return this.statisticalLimit;
    }

    @Generated
    public DeterministicLimitEntity getDeterministicLimit() {
        return this.deterministicLimit;
    }

    @Generated
    public MeasurementUnitEntity getMeasurementUnit() {
        return this.measurementUnit;
    }

    @Generated
    public InstrumentEntity getInstrument() {
        return this.instrument;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setAcronym(String acronym) {
        this.acronym = acronym;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEquation(String equation) {
        this.equation = equation;
    }

    @Generated
    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @JsonIgnoreProperties(value={"output"})
    @Generated
    public void setStatisticalLimit(StatisticalLimitEntity statisticalLimit) {
        this.statisticalLimit = statisticalLimit;
    }

    @JsonIgnoreProperties(value={"output"})
    @Generated
    public void setDeterministicLimit(DeterministicLimitEntity deterministicLimit) {
        this.deterministicLimit = deterministicLimit;
    }

    @Generated
    public void setMeasurementUnit(MeasurementUnitEntity measurementUnit) {
        this.measurementUnit = measurementUnit;
    }

    @JsonIgnoreProperties(value={"outputs"})
    @Generated
    public void setInstrument(InstrumentEntity instrument) {
        this.instrument = instrument;
    }

    @Generated
    public OutputEntity() {
    }

    @Generated
    public OutputEntity(Long id, String acronym, String name, String equation, Integer precision, Boolean active, StatisticalLimitEntity statisticalLimit, DeterministicLimitEntity deterministicLimit, MeasurementUnitEntity measurementUnit, InstrumentEntity instrument) {
        this.id = id;
        this.acronym = acronym;
        this.name = name;
        this.equation = equation;
        this.precision = precision;
        this.active = active;
        this.statisticalLimit = statisticalLimit;
        this.deterministicLimit = deterministicLimit;
        this.measurementUnit = measurementUnit;
        this.instrument = instrument;
    }
}

