/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.configs.security;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.geosegbar.entities.UserEntity;
import com.geosegbar.exceptions.JWTException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TokenService {
    @Value(value="${api.security.token.secret}")
    private String secret;

    public String generateToken(UserEntity user) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)this.secret);
            LocalDateTime expiryDate = LocalDateTime.now().plusHours(12L);
            String token = JWT.create().withIssuer("GeoSegBar").withSubject(user.getEmail()).withExpiresAt(this.generateExpirationDate()).sign(algorithm);
            user.setLastToken(token);
            user.setTokenExpiryDate(expiryDate);
            return token;
        }
        catch (JWTCreationException exception) {
            throw new JWTException("Erro ao gerar token!");
        }
    }

    public String validateToken(String token) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)this.secret);
            return JWT.require((Algorithm)algorithm).withIssuer("GeoSegBar").build().verify(token).getSubject();
        }
        catch (JWTVerificationException exception) {
            return null;
        }
    }

    public boolean isTokenValid(String token) {
        if (token == null) {
            return false;
        }
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)this.secret);
            JWT.require((Algorithm)algorithm).withIssuer("GeoSegBar").build().verify(token);
            return true;
        }
        catch (JWTVerificationException exception) {
            return false;
        }
    }

    private Instant generateExpirationDate() {
        return LocalDateTime.now().plusHours(12L).toInstant(ZoneOffset.of("-3"));
    }
}

