/*
 * Decompiled with CFR 0.152.
 */
package com.geosegbar.configs.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.Arrays;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableCaching
public class CacheManagerConfig {
    @Bean(value={"instrumentGraphCacheManager"})
    @Primary
    public CacheManager instrumentGraphCacheManager() {
        SimpleCacheManager cacheManager = new SimpleCacheManager();
        cacheManager.setCaches(Arrays.asList(new CaffeineCache("graphPatternsByDam", Caffeine.newBuilder().maximumSize(50L).expireAfterWrite(Duration.ofMinutes(20L)).expireAfterAccess(Duration.ofMinutes(10L)).build()), new CaffeineCache("graphPatternById", Caffeine.newBuilder().maximumSize(300L).expireAfterWrite(Duration.ofMinutes(15L)).expireAfterAccess(Duration.ofMinutes(8L)).build()), new CaffeineCache("graphPatternsByInstrument", Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(Duration.ofMinutes(15L)).expireAfterAccess(Duration.ofMinutes(8L)).build()), new CaffeineCache("folderWithPatterns", Caffeine.newBuilder().maximumSize(80L).expireAfterWrite(Duration.ofMinutes(18L)).expireAfterAccess(Duration.ofMinutes(10L)).build()), new CaffeineCache("damFoldersWithPatterns", Caffeine.newBuilder().maximumSize(25L).expireAfterWrite(Duration.ofMinutes(25L)).expireAfterAccess(Duration.ofMinutes(12L)).build()), new CaffeineCache("graphProperties", Caffeine.newBuilder().maximumSize(400L).expireAfterWrite(Duration.ofMinutes(12L)).expireAfterAccess(Duration.ofMinutes(6L)).build()), new CaffeineCache("graphAxes", Caffeine.newBuilder().maximumSize(200L).expireAfterWrite(Duration.ofMinutes(20L)).expireAfterAccess(Duration.ofMinutes(10L)).build())));
        return cacheManager;
    }

    @Bean(value={"instrumentTabulateCacheManager"})
    public CacheManager instrumentTabulateCacheManager() {
        SimpleCacheManager cacheManager = new SimpleCacheManager();
        cacheManager.setCaches(Arrays.asList(new CaffeineCache("tabulatePatterns", Caffeine.newBuilder().maximumSize(300L).expireAfterWrite(Duration.ofMinutes(15L)).expireAfterAccess(Duration.ofMinutes(8L)).build()), new CaffeineCache("tabulatePatternsByDam", Caffeine.newBuilder().maximumSize(50L).expireAfterWrite(Duration.ofMinutes(20L)).expireAfterAccess(Duration.ofMinutes(10L)).build()), new CaffeineCache("tabulatePatternsByFolder", Caffeine.newBuilder().maximumSize(80L).expireAfterWrite(Duration.ofMinutes(15L)).expireAfterAccess(Duration.ofMinutes(8L)).build()), new CaffeineCache("tabulateFolderWithPatterns", Caffeine.newBuilder().maximumSize(80L).expireAfterWrite(Duration.ofMinutes(18L)).expireAfterAccess(Duration.ofMinutes(10L)).build()), new CaffeineCache("damTabulateFoldersWithPatterns", Caffeine.newBuilder().maximumSize(25L).expireAfterWrite(Duration.ofMinutes(25L)).expireAfterAccess(Duration.ofMinutes(12L)).build())));
        return cacheManager;
    }

    @Bean(value={"userCacheManager"})
    public CacheManager userCacheManager() {
        SimpleCacheManager cacheManager = new SimpleCacheManager();
        cacheManager.setCaches(Arrays.asList(new CaffeineCache("userById", Caffeine.newBuilder().maximumSize(500L).expireAfterWrite(Duration.ofMinutes(30L)).expireAfterAccess(Duration.ofMinutes(15L)).build()), new CaffeineCache("userByEmail", Caffeine.newBuilder().maximumSize(300L).expireAfterWrite(Duration.ofMinutes(20L)).expireAfterAccess(Duration.ofMinutes(10L)).build()), new CaffeineCache("allUsers", Caffeine.newBuilder().maximumSize(10L).expireAfterWrite(Duration.ofMinutes(10L)).expireAfterAccess(Duration.ofMinutes(5L)).build()), new CaffeineCache("usersByRoleAndClient", Caffeine.newBuilder().maximumSize(50L).expireAfterWrite(Duration.ofMinutes(15L)).expireAfterAccess(Duration.ofMinutes(8L)).build()), new CaffeineCache("usersByCreatedBy", Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(Duration.ofMinutes(20L)).expireAfterAccess(Duration.ofMinutes(10L)).build()), new CaffeineCache("userExistence", Caffeine.newBuilder().maximumSize(200L).expireAfterWrite(Duration.ofMinutes(5L)).expireAfterAccess(Duration.ofMinutes(2L)).build())));
        return cacheManager;
    }

    @Bean(value={"checklistCacheManager"})
    public CacheManager checklistCacheManager() {
        SimpleCacheManager cacheManager = new SimpleCacheManager();
        cacheManager.setCaches(Arrays.asList(new CaffeineCache("checklistsByDam", Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(Duration.ofMinutes(15L)).expireAfterAccess(Duration.ofMinutes(8L)).build()), new CaffeineCache("checklistsWithAnswersByDam", Caffeine.newBuilder().maximumSize(50L).expireAfterWrite(Duration.ofMinutes(10L)).expireAfterAccess(Duration.ofMinutes(5L)).build()), new CaffeineCache("checklistsWithAnswersByClient", Caffeine.newBuilder().maximumSize(30L).expireAfterWrite(Duration.ofMinutes(12L)).expireAfterAccess(Duration.ofMinutes(6L)).build()), new CaffeineCache("checklistById", Caffeine.newBuilder().maximumSize(200L).expireAfterWrite(Duration.ofMinutes(20L)).expireAfterAccess(Duration.ofMinutes(10L)).build()), new CaffeineCache("checklistForDam", Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(Duration.ofMinutes(15L)).expireAfterAccess(Duration.ofMinutes(8L)).build()), new CaffeineCache("allChecklists", Caffeine.newBuilder().maximumSize(5L).expireAfterWrite(Duration.ofMinutes(10L)).expireAfterAccess(Duration.ofMinutes(5L)).build()), new CaffeineCache("allChecklistResponses", Caffeine.newBuilder().maximumSize(5L).expireAfterWrite(Duration.ofMinutes(10L)).expireAfterAccess(Duration.ofMinutes(5L)).build()), new CaffeineCache("checklistResponseById", Caffeine.newBuilder().maximumSize(200L).expireAfterWrite(Duration.ofMinutes(20L)).expireAfterAccess(Duration.ofMinutes(10L)).build()), new CaffeineCache("checklistResponsesByDam", Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(Duration.ofMinutes(15L)).expireAfterAccess(Duration.ofMinutes(8L)).build()), new CaffeineCache("checklistResponseDetail", Caffeine.newBuilder().maximumSize(200L).expireAfterWrite(Duration.ofMinutes(20L)).expireAfterAccess(Duration.ofMinutes(10L)).build()), new CaffeineCache("checklistResponsesByUser", Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(Duration.ofMinutes(15L)).expireAfterAccess(Duration.ofMinutes(8L)).build()), new CaffeineCache("checklistResponsesByDate", Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(Duration.ofMinutes(15L)).expireAfterAccess(Duration.ofMinutes(8L)).build()), new CaffeineCache("damLastChecklist", Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(Duration.ofMinutes(15L)).expireAfterAccess(Duration.ofMinutes(8L)).build()), new CaffeineCache("checklistResponsesByDamPaged", Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(Duration.ofMinutes(10L)).expireAfterAccess(Duration.ofMinutes(5L)).build()), new CaffeineCache("checklistResponsesByUserPaged", Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(Duration.ofMinutes(10L)).expireAfterAccess(Duration.ofMinutes(5L)).build()), new CaffeineCache("checklistResponsesByDatePaged", Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(Duration.ofMinutes(10L)).expireAfterAccess(Duration.ofMinutes(5L)).build()), new CaffeineCache("allChecklistResponsesPaged", Caffeine.newBuilder().maximumSize(5L).expireAfterWrite(Duration.ofMinutes(10L)).expireAfterAccess(Duration.ofMinutes(5L)).build()), new CaffeineCache("checklistResponsesByClient", Caffeine.newBuilder().maximumSize(50L).expireAfterWrite(Duration.ofMinutes(12L)).expireAfterAccess(Duration.ofMinutes(6L)).build()), new CaffeineCache("clientLatestDetailedChecklistResponses", Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(Duration.ofMinutes(15L)).expireAfterAccess(Duration.ofMinutes(10L)).build())));
        return cacheManager;
    }

    @Bean(value={"instrumentCacheManager"})
    public CacheManager instrumentCacheManager() {
        SimpleCacheManager cacheManager = new SimpleCacheManager();
        cacheManager.setCaches(Arrays.asList(new CaffeineCache("instrumentById", Caffeine.newBuilder().maximumSize(300L).expireAfterWrite(Duration.ofMinutes(15L)).expireAfterAccess(Duration.ofMinutes(10L)).build()), new CaffeineCache("instrumentWithDetails", Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(Duration.ofMinutes(12L)).expireAfterAccess(Duration.ofMinutes(8L)).build()), new CaffeineCache("instrumentsByClient", Caffeine.newBuilder().maximumSize(50L).expireAfterWrite(Duration.ofMinutes(10L)).expireAfterAccess(Duration.ofMinutes(5L)).build()), new CaffeineCache("instrumentsByFilters", Caffeine.newBuilder().maximumSize(200L).expireAfterWrite(Duration.ofMinutes(10L)).expireAfterAccess(Duration.ofMinutes(5L)).build()), new CaffeineCache("instrumentsByDam", Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(Duration.ofMinutes(15L)).expireAfterAccess(Duration.ofMinutes(8L)).build()), new CaffeineCache("allInstruments", Caffeine.newBuilder().maximumSize(5L).expireAfterWrite(Duration.ofMinutes(5L)).expireAfterAccess(Duration.ofMinutes(3L)).build()), new CaffeineCache("instrumentResponseDTO", Caffeine.newBuilder().maximumSize(500L).expireAfterWrite(Duration.ofMinutes(10L)).expireAfterAccess(Duration.ofMinutes(5L)).build())));
        return cacheManager;
    }

    @Bean(value={"readingCacheManager"})
    public CacheManager readingCacheManager() {
        SimpleCacheManager cacheManager = new SimpleCacheManager();
        cacheManager.setCaches(Arrays.asList(new CaffeineCache("readingById", Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(Duration.ofMinutes(15L)).expireAfterAccess(Duration.ofMinutes(8L)).build()), new CaffeineCache("readingsByInstrument", Caffeine.newBuilder().maximumSize(300L).expireAfterWrite(Duration.ofMinutes(10L)).expireAfterAccess(Duration.ofMinutes(5L)).build()), new CaffeineCache("readingsByOutput", Caffeine.newBuilder().maximumSize(300L).expireAfterWrite(Duration.ofMinutes(10L)).expireAfterAccess(Duration.ofMinutes(5L)).build()), new CaffeineCache("readingsByFilters", Caffeine.newBuilder().maximumSize(500L).expireAfterWrite(Duration.ofMinutes(5L)).expireAfterAccess(Duration.ofMinutes(3L)).build()), new CaffeineCache("instrumentLimitStatus", Caffeine.newBuilder().maximumSize(200L).expireAfterWrite(Duration.ofMinutes(5L)).expireAfterAccess(Duration.ofMinutes(2L)).build()), new CaffeineCache("clientInstrumentLimitStatuses", Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(Duration.ofMinutes(5L)).expireAfterAccess(Duration.ofMinutes(2L)).build()), new CaffeineCache("readingResponseDTO", Caffeine.newBuilder().maximumSize(2000L).expireAfterWrite(Duration.ofMinutes(15L)).expireAfterAccess(Duration.ofMinutes(8L)).build()), new CaffeineCache("latestReadings", Caffeine.newBuilder().maximumSize(500L).expireAfterWrite(Duration.ofMinutes(5L)).expireAfterAccess(Duration.ofMinutes(2L)).build()), new CaffeineCache("readingExists", Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(Duration.ofMinutes(10L)).expireAfterAccess(Duration.ofMinutes(5L)).build()), new CaffeineCache("groupedReadings", Caffeine.newBuilder().maximumSize(300L).expireAfterWrite(Duration.ofMinutes(10L)).expireAfterAccess(Duration.ofMinutes(5L)).build()), new CaffeineCache("readingInputValues", Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(Duration.ofMinutes(15L)).expireAfterAccess(Duration.ofMinutes(8L)).build()), new CaffeineCache("multiInstrumentReadings", Caffeine.newBuilder().maximumSize(300L).expireAfterWrite(Duration.ofMinutes(5L)).expireAfterAccess(Duration.ofMinutes(2L)).build()), new CaffeineCache("clientInstrumentLatestGroupedReadings", Caffeine.newBuilder().maximumSize(200L).expireAfterWrite(Duration.ofMinutes(10L)).expireAfterAccess(Duration.ofMinutes(5L)).build())));
        return cacheManager;
    }
}

